/*
    JSXGraph 1.9.1

    Copyright 2008-2024
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(){"use strict";JXG.IntergeoReader=function(t,e){var i;this.board=t,i=this.prepareString(e),this.tree=JXG.XML.parse(i)},JXG.extend(JXG.IntergeoReader.prototype,{objects:{},read:function(){this.board.origin={},this.board.origin.usrCoords=[1,0,0],this.board.origin.scrCoords=[1,400,300],this.board.unitX=30,this.board.unitY=30,this.readElements(this.tree.getElementsByTagName("elements")),this.readConstraints(this.tree.getElementsByTagName("constraints")),this.cleanUp(),this.board.fullUpdate(),this.readDisplay(this.tree.getElementsByTagName("display")),this.board.fullUpdate()},readElement:function(t,e){var i;(i=t[0].childNodes[e]).nodeType>1||("point"===i.nodeName?this.storePoint(i):"line"===i.nodeName||"line_segment"===i.nodeName||"ray"===i.nodeName||"vector"===i.nodeName?this.storeLine(i):"circle"===i.nodeName||"conic"===i.nodeName?this.storeConic(i):JXG.debug("Not implemented: "+i.nodeName+" "+i.getAttribute("id")))},readElements:function(t){var e;for(e=0;e<t[0].childNodes.length;e++)this.readElement(t,e)},storePoint:function(t){for(var e=0,i=0,s=0,o=t.childNodes[e],n=[],d=[];o.nodeType>1;)e+=1,o=t.childNodes[e];if("homogeneous_coordinates"===o.nodeName){for(i=0;i<o.childNodes.length;i++)if(1===o.childNodes[i].nodeType)if("double"===o.childNodes[i].nodeName)n.push(o.childNodes[i].firstChild.data);else{if("complex"!==o.childNodes[i].nodeName)return void JXG.debug("Not implemented: "+o.childNodes[i].nodeName);for(s=0;s<o.childNodes[i].childNodes.length;s++)"double"===o.childNodes[i].childNodes[s].nodeName&&n.push(o.childNodes[i].childNodes[s].firstChild.data)}for(i=0;i<n.length;i++)n[i]=parseFloat(n[i]);if(3===n.length)d=[n[2],n[0],n[1]];else{if(!(6===n.length&&Math.abs(n[1])<1e-10&&Math.abs(n[3])<1e-10&&Math.abs(n[5])<1e-10))return void JXG.debug("type not supported, yet");d=[n[4],n[0],n[2]]}}else if("euclidean_coordinates"===o.nodeName||"euclidian_coordinates"===o.nodeName){for(i=0;i<o.childNodes.length;i++)1===o.childNodes[i].nodeType&&n.push(o.childNodes[i].firstChild.data);for(i=0;i<n.length;i++)n[i]=parseFloat(n[i]);d=[n[0],n[1]]}else{if("polar_coordinates"!==o.nodeName)return void JXG.debug("This coordinate type is not yet implemented: "+o.nodeName);for(i=0;i<o.childNodes.length;i++)1===o.childNodes[i].nodeType&&n.push(o.childNodes[i].firstChild.data);for(i=0;i<n.length;i++)n[i]=parseFloat(n[i]);d=[n[0]*Math.cos(n[1]),n[0]*Math.sin(n[1])]}this.objects[t.getAttribute("id")]={id:t.getAttribute("id"),coords:null},this.objects[t.getAttribute("id")].coords=d,this.objects[t.getAttribute("id")].id=t.getAttribute("id"),this.objects[t.getAttribute("id")].exists=!1,this.objects[t.getAttribute("id")].i2geoType="point"},storeLine:function(t){var e,i,s,o;for(this.objects[t.getAttribute("id")]={id:t.getAttribute("id"),coords:null},e=0,i=t.childNodes[e];i.nodeType>1;)e+=1,i=t.childNodes[e];if("homogeneous_coordinates"===i.nodeName){for(s=[],o=0;o<i.childNodes.length;o++)1===i.childNodes[o].nodeType&&"double"===i.childNodes[o].nodeName&&s.push(parseFloat(i.childNodes[o].firstChild.data));this.objects[t.getAttribute("id")].coords=s,this.objects[t.getAttribute("id")].id=t.getAttribute("id"),this.objects[t.getAttribute("id")].exists=!1,this.objects[t.getAttribute("id")].i2geoType="line"}},storeConic:function(t){var e,i,s,o;for(this.objects[t.getAttribute("id")]={id:t.getAttribute("id"),coords:null},e=0,s=t.childNodes[e];s.nodeType>1;)e+=1,s=t.childNodes[e];if("matrix"===s.nodeName){for(o=[],i=0;i<s.childNodes.length;i++)1===s.childNodes[i].nodeType&&"double"===s.childNodes[i].nodeName&&o.push(parseFloat(s.childNodes[i].firstChild.data));this.objects[t.getAttribute("id")].coords=o,this.objects[t.getAttribute("id")].id=t.getAttribute("id"),this.objects[t.getAttribute("id")].exists=!1,this.objects[t.getAttribute("id")].i2geoType="conic"}},readConstraint:function(t,e){var i,s;(s=t[0].childNodes[e]).nodeType>1||("line_through_two_points"===s.nodeName?this.addLineThroughTwoPoints(s,!1):"ray_from_point_through_point"===s.nodeName?this.addLineThroughTwoPoints(s,!0):"line_through_point"===s.nodeName?this.addLineThroughPoint(s):"line_parallel_to_line_through_point"===s.nodeName?this.addLineParallelToLineThroughPoint(s,!1):"ray_from_point_and_vector"===s.nodeName?this.addLineParallelToLineThroughPoint(s,!0):"line_perpendicular_to_line_through_point"===s.nodeName?this.addLinePerpendicularToLineThroughPoint(s):"line_segment_by_points"===s.nodeName?this.addLineSegmentByTwoPoints(s):"vector_from_point_to_point"===s.nodeName?this.addVectorFromPointToPoint(s):"endpoints_of_line_segment"===s.nodeName?this.addEndpointsOfLineSegment(s):"free_line"===s.nodeName?this.addFreeLine(s):"point_on_line"===s.nodeName||"point_on_line_segment"===s.nodeName?this.addPointOnLine(s):"point_on_circle"===s.nodeName?this.addPointOnCircle(s):"angular_bisector_of_three_points"===s.nodeName?this.addAngularBisectorOfThreePoints(s,!1):"angular_bisectors_of_two_lines"===s.nodeName?this.addAngularBisectorsOfTwoLines(s):"line_angular_bisector_of_three_points"===s.nodeName?this.addAngularBisectorOfThreePoints(s,!0):"line_angular_bisectors_of_two_lines"===s.nodeName?this.addAngularBisectorsOfTwoLines(s):"midpoint_of_two_points"===s.nodeName||"midpoint"===s.nodeName?this.addMidpointOfTwoPoints(s):"midpoint_of_line_segment"===s.nodeName||"midpoint_line_segment"===s.nodeName?this.addMidpointOfLineSegment(s):"point_intersection_of_two_lines"===s.nodeName?this.addPointIntersectionOfTwoLines(s):"locus_defined_by_point"===s.nodeName?this.addLocusDefinedByPoint(s):"locus_defined_by_point_on_line"===s.nodeName||"locus_defined_by_point_on_line_segment"===s.nodeName?this.addLocusDefinedByPointOnLine(s):"locus_defined_by_line_through_point"===s.nodeName?this.addLocusDefinedByLineThroughPoint(s):"locus_defined_by_point_on_circle"===s.nodeName?this.addLocusDefinedByPointOnCircle(s):"circle_by_three_points"===s.nodeName?this.addCircleByThreePoints(s):"circle_by_center_and_point"===s.nodeName?this.addCircleByCenterAndPoint(s):"center_of_circle"===s.nodeName?this.addCenterOfCircle(s):"intersection_points_of_two_circles"===s.nodeName?this.addIntersectionPointsOfTwoCircles(s):"intersection_points_of_circle_and_line"===s.nodeName?this.addIntersectionPointsOfCircleAndLine(s):"other_intersection_point_of_two_circles"===s.nodeName?this.addOtherIntersectionPointOfTwoCircles(s):"other_intersection_point_of_circle_and_line"===s.nodeName?this.addOtherIntersectionPointOfCircleAndLine(s):"circle_tangent_lines_by_point"===s.nodeName?this.addCircleTangentLinesByPoint(s):"polygon_by_vertices"===s.nodeName?this.addPolygonByVertices(s):(i=this.readParams(s),JXG.debug("readConstraints: not implemented: "+s.nodeName+": "+i[0])))},readConstraints:function(t){var e;for(this.board.options.point.strokeColor="blue",this.board.options.point.fillColor="blue",e=0;e<t[0].childNodes.length;e++)this.readConstraint(t,e)},setAttributes:function(t){t.setAttribute({strokecolor:this.board.options.point.strokeColor,fillColor:this.board.options.point.fillColor})},readParams:function(t){var e,i=[];for(e=0;e<t.childNodes.length;e++)1===t.childNodes[e].nodeType&&i.push(t.childNodes[e].firstChild.data);return i},addPoint:function(t){return t.exists||(t.exists=!0,(t=this.board.create("point",t.coords,{name:t.id})).setAttribute({strokecolor:"red",fillColor:"red"})),t},addLine:function(t){var e,i,s=this.objects[t].coords;for(e=0;e<s.length;e++)s[e]=parseFloat(s[e]);i=this.board.create("line",[s[2],s[0],s[1]],{name:t,strokeColor:"black",withLabel:!0}),this.objects[t]=i},addConic:function(t){var e;return t.exists||(e=t.coords,(t=this.board.create("conic",[e[0],e[4],e[8],e[1],e[5],e[2]],{name:t.id})).exists=!0),t},cleanUp:function(){var t;for(t in this.objects)this.objects.hasOwnProperty(t)&&!1===this.objects[t].exists&&("point"===this.objects[t].i2geoType?this.addPoint(this.objects[t]):"line"===this.objects[t].i2geoType?this.addLine(this.objects[t]):"conic"===this.objects[t].i2geoType?this.addConic(this.objects[t]):JXG.debug("forgotten: "+this.objects[t].id+" of type "+this.objects[t].i2geoType))},addLineThroughTwoPoints:function(t,e){var i,s,o,n=this.readParams(t);i=this.addPoint(this.objects[n[1]]),s=this.addPoint(this.objects[n[2]]),o=this.board.create("line",[i.id,s.id],{name:n[0],withLabel:!0,straightFirst:!e,straightLast:!0}),this.objects[n[0]]=o,this.objects[n[0]].exists=!0},addLineThroughPoint:function(t){var e,i,s=this.readParams(t),o=this.objects[s[0]].coords,n=this.addPoint(this.objects[s[1]]);for(e=0;e<o.length;e++)o[e]=parseFloat(o[e]);i=this.board.create("line",[function(){return o[2]-o[0]*n.X()-o[1]*n.Y()-o[2]*n.Z()},o[0],o[1]],{name:s[0],strokeColor:"black",withLabel:!0}),this.objects[s[0]]=i,this.objects[s[0]].exists=!0},addLineParallelToLineThroughPoint:function(t,e){var i,s,o,n=this.readParams(t);i=this.addPoint(this.objects[n[1]]),s=this.addPoint(this.objects[n[2]]),o=this.board.create("parallel",[i.id,s.id],{name:n[0],withLabel:!0,straightFirst:!e,straightLast:!0}),this.objects[n[0]]=o,this.objects[n[0]].exists=!0},addLinePerpendicularToLineThroughPoint:function(t){var e,i,s,o=this.readParams(t);e=this.addPoint(this.objects[o[1]]),i=this.addPoint(this.objects[o[2]]),s=this.board.create("perpendicular",[e.id,i.id],{name:o[0],id:o[0],straightFirst:!0,straightLast:!0,point:{name:o[0]+"foot",id:o[0]+"foot"},withLabel:!0}),this.objects[o[0]]=s,this.objects[o[0]].exists=!0},addLineSegmentByTwoPoints:function(t){var e,i,s,o=this.readParams(t);e=this.addPoint(this.objects[o[1]]),i=this.addPoint(this.objects[o[2]]),s=this.board.create("line",[e.id,i.id],{name:o[0],straightFirst:!1,straightLast:!1,strokeColor:"black",withLabel:!0}),this.objects[o[0]]=s,this.objects[o[0]].exists=!0},addPointIntersectionOfTwoLines:function(t){var e=this.readParams(t),i=this.objects[e[1]],s=this.objects[e[2]];this.objects[e[0]]=this.board.create("intersection",[i,s,0],{name:e[0],id:e[0],withLabel:!0}),this.setAttributes(this.objects[e[0]]),this.objects[e[0]].exists=!0},addFreeLine:function(t){var e=this.readParams(t),i=this.objects[e[0]].coords[0],s=this.objects[e[0]].coords[1],o=this.objects[e[0]].coords[2];this.objects[e[0]]=this.board.create("line",[o,i,s],{name:e[0],id:e[0],withLabel:!0}),this.objects[e[0]].exists=!0},addPointOnLine:function(t){var e=this.readParams(t),i=this.board.select(e[1]);this.board.create("glider",[0,0,i],{name:e[0],id:e[0],withLabel:!0}),this.objects[e[0]].exists=!0},addPointOnCircle:function(t){var e=this.readParams(t),i=this.board.select(e[1]);i.update(),this.board.create("glider",[this.objects[e[0]].coords[1],this.objects[e[0]].coords[2],i],{name:e[0],id:e[0],withLabel:!0}),this.objects[e[0]].exists=!0},addEndpointsOfLineSegment:function(t){var e=this.readParams(t),i=this.objects[e[2]],s=this.addPoint(this.objects[e[0]]),o=this.addPoint(this.objects[e[1]]);s.addConstraint([function(){return i.point1.Z()},function(){return i.point1.X()},function(){return i.point1.Y()}]),o.addConstraint([function(){return i.point2.Z()},function(){return i.point2.X()},function(){return i.point2.Y()}]),this.setAttributes(s),this.setAttributes(o)},addAngularBisectorOfThreePoints:function(t,e){var i,s,o,n,d=this.readParams(t);i=this.addPoint(this.objects[d[1]]),s=this.addPoint(this.objects[d[2]]),o=this.addPoint(this.objects[d[3]]),n=this.board.create("bisector",[i.id,s.id,o.id],{name:d[0],id:d[0],withLabel:!0,straightFirst:e,straightLast:!0,strokeColor:"#000000"}),this.objects[d[0]]=n,this.objects[d[0]].exists=!0},addMidpointOfTwoPoints:function(t){var e,i,s,o=this.readParams(t);e=this.addPoint(this.objects[o[1]]),i=this.addPoint(this.objects[o[2]]),s=this.board.create("midpoint",[e.id,i.id],{name:o[0]}),this.setAttributes(s),this.objects[o[0]].exists=!0},addMidpointOfLineSegment:function(t){var e=this.readParams(t),i=this.board.select(e[1]),s=this.board.create("midpoint",[i.point1,i.point2],{name:e[0]});this.setAttributes(s),this.objects[e[0]].exists=!0},addCircleByThreePoints:function(t){var e,i=this.readParams(t),s=[];for(e=0;e<3;e++)s[e]=this.addPoint(this.objects[i[e+1]]);this.board.create("circumcircle",s,{name:i[0],id:i[0],point:{name:i[0]+"c",id:i[0]+"c"},withLabel:!0}),this.objects[i[0]].exists=!0},addCenterOfCircle:function(t){var e=this.readParams(t),i=this.board.select(e[1]),s=this.board.create("point",[function(){return i.center.X()},function(){return i.center.Y()}],{name:e[0],id:e[0],withLabel:!0});this.setAttributes(s),this.objects[e[0]].exists=!0},addCircleTangentLinesByPoint:function(t){var e,i,s,o,n,d=this.readParams(t),r=this.board.select(d[2]),a=this.addPoint(this.objects[d[3]]);e=this.board.create("line",[function(){return JXG.Math.matVecMult(r.quadraticform,a.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(r.quadraticform,a.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(r.quadraticform,a.coords.usrCoords)[2]}],{visible:!1}),i=this.board.create("intersection",[r,e,0],{visible:!1}),s=this.board.create("intersection",[r,e,1],{visible:!1}),o=this.board.create("tangent",[i,r]),n=this.board.create("tangent",[s,r]),this.objects[d[0]]=o,this.objects[d[1]]=n,this.objects[d[0]].exists=!0,this.objects[d[1]].exists=!0},addIntersectionPointsOfTwoCircles:function(t){var e,i,s=this.readParams(t),o=this.board.select(s[2]),n=this.board.select(s[3]);e=this.board.create("intersection",[o,n,0],{name:s[0],id:s[0],withLabel:!0}),i=this.board.create("intersection",[o,n,1],{name:s[1],id:s[1],withLabel:!0}),this.setAttributes(e),this.setAttributes(i),this.objects[s[0]].exists=!0,this.objects[s[1]].exists=!0},addIntersectionPointsOfCircleAndLine:function(t){var e,i,s=this.readParams(t),o=this.board.select(s[2]),n=this.board.select(s[3]);e=this.board.create("intersection",[o,n,0],{name:s[0],id:s[0],withLabel:!0}),i=this.board.create("intersection",[o,n,1],{name:s[1],id:s[1],withLabel:!0}),this.setAttributes(e),this.setAttributes(i),this.objects[s[0]].exists=!0,this.objects[s[1]].exists=!0},addCircleByCenterAndPoint:function(t){var e=this.readParams(t),i=this.addPoint(this.objects[e[1]]),s=this.addPoint(this.objects[e[2]]);this.board.create("circle",[i.id,s.id],{name:e[0],id:e[0],withLabel:!0}),this.objects[e[0]].exists=!0},addOtherIntersectionPointOfTwoCircles:function(t){var e,i=this.readParams(t),s=this.board.select(i[2]),o=this.board.select(i[3]),n=this.board.select(i[1]);e=this.board.create("otherintersection",[s,o,n],{name:i[0],id:i[0],withLabel:!0}),this.setAttributes(e),this.objects[i[0]].exists=!0},addOtherIntersectionPointOfCircleAndLine:function(t){this.addOtherIntersectionPointOfTwoCircles(t)},addAngularBisectorsOfTwoLines:function(t){var e=this.readParams(t),i=this.objects[e[2]],s=this.objects[e[3]];this.board.create("bisectorlines",[i,s],{line1:{name:e[0],id:e[0],straightFirst:!0,straightLast:!0},line2:{name:e[1],id:e[1],straightFirst:!0,straightLast:!0},withLabel:!0}),this.objects[e[0]].exists=!0,this.objects[e[1]].exists=!0},addPolygonByVertices:function(t){var e,i,s=[],o=[],n=this.readParams(t);for(e=0;e<t.childNodes.length;e++)if(1===t.childNodes[e].nodeType&&"list_of_vertices"===t.childNodes[e].nodeName){i=t.childNodes[e],s=this.readParams(i);break}for(e=0;e<s.length;e++)o.push(this.addPoint(this.objects[s[e]]));this.board.create("polygon",o,{name:n[0],id:n[0],withLabel:!0}),this.objects[n[0]].exists=!0},addVectorFromPointToPoint:function(t){var e,i,s,o=this.readParams(t);i=this.addPoint(this.objects[o[1]]),s=this.addPoint(this.objects[o[2]]),e=this.board.create("arrow",[i.id,s.id],{name:o[0]}),this.setAttributes(e),this.objects[o[0]].exists=!0},addLocusDefinedByPoint:function(t){var e=this.readParams(t),i=this.board.select(e[1]);i.setAttribute({trace:!0}),this.objects[e[1]]=i,this.setAttributes(i)},addLocusDefinedByPointOnLine:function(t){var e=this.readParams(t),i=this.board.select(e[1]);i.setAttribute({trace:!0}),this.objects[e[1]]=i,this.setAttributes(i)},addLocusDefinedByLineThroughPoint:function(t){var e=this.readParams(t),i=this.board.select(e[1]);i.setAttribute({trace:!0}),this.objects[e[1]]=i,this.setAttributes(i)},addLocusDefinedByPointOnCircle:function(t){var e=this.readParams(t),i=this.board.select(e[1]);i.setAttribute({trace:!0}),this.objects[e[1]]=i,this.setAttributes(i)},prepareString:function(t){var e,i=[],s=!1;if("PK"!==t.slice(0,2)&&31!==JXG.Util.UTF8.asciiCharCodeAt(t.slice(0,1),0)||(s=!0),s||0===t.indexOf("<")||(t=JXG.Util.Base64.decode(t)),0!==t.indexOf("<")){for(e=0;e<t.length;e++)i[e]=JXG.Util.UTF8.asciiCharCodeAt(t,e);t=new JXG.Util.Unzip(i).unzipFile("construction/intergeo.xml")}return t},readDisplayProperty:function(t,e){var i,s,o,n,d,r={};if(!((s=t[0].childNodes[e]).nodeType>1))if("background-color"===s.nodeName)this.board.containerObj.style.backgroundColor=s.firstChild.data;else if("style"===s.nodeName){for(o=this.board.select(s.getAttribute("ref")),i=0;i<s.childNodes.length;i++)1===s.childNodes[i].nodeType&&(n=s.childNodes[i].nodeName,d=s.childNodes[i].firstChild.data,"stroke"===n?n="strokeColor":"stroke-width"===n||"border-width"===n?n="strokeWidth":"fill"===n?n="fillColor":"fill-opacity"===n?n="fillOpacity":"border-opacity"===n?n="strokeOpacity":"point-size"===n?n="size":"label"===n?n="name":"point-style"===n&&(n="face","circle"===d?d="o":"cross"===d?d="+":"x-mark"===d?d="x":"square"===d?d="[]":"triangle"===d?d="triangleup":"point"===d?d="o":JXG.debug("Display: not implemented"+s.nodeName)),r[n]=d);o.setAttribute(r)}else JXG.debug("Display: not implemented"+s.nodeName)},readDisplay:function(t){var e;if(JXG.exists(t)&&JXG.isArray(t))for(e=0;e<t[0].childNodes.length;e++)this.readDisplayProperty(t,e)}}),JXG.registerReader(JXG.IntergeoReader,["i2g","xml","intergeo"])}();
