/*
    JSXGraph 1.9.1

    Copyright 2008-2024
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(){"use strict";JXG.GeonextReader=function(e,t){var i;this.board=e,i=this.prepareString(t),this.tree=JXG.XML.parse(i)},JXG.extend(JXG.GeonextReader.prototype,{changeOriginIds:function(e,t){return"gOOe0"===t||"gXOe0"===t||"gYOe0"===t||"gXLe0"===t||"gYLe0"===t?e.id+t:t},gEBTN:function(e,t,i,r){var s=[];return JXG.exists(e||!e.getElementsByTagName)?(JXG.exists(r)||(r=!0),i=i||0,e.getElementsByTagName&&(s=e.getElementsByTagName(t)),s.length>0&&(s=s[i],r&&s.firstChild&&(s=s.firstChild.data)),s):e},colorProperties:function(e,t){var i,r=this.gEBTN(t,"color",0,!1);return i=JXG.rgba2rgbo(this.gEBTN(r,"stroke")),e.strokeColor=i[0],e.strokeOpacity=i[1],i=JXG.rgba2rgbo(this.gEBTN(r,"lighting")),e.highlightStrokeColor=i[0],e.highlightStrokeOpacity=i[1],i=JXG.rgba2rgbo(this.gEBTN(r,"fill")),e.fillColor=i[0],e.fillOpacity=i[1],e.highlightFillColor=e.fillColor,e.highlightFillOpacity=e.fillOpacity,i=JXG.rgba2rgbo(this.gEBTN(r,"label")),e.labelColor=i[0],e.withLabel=i[1]>0,e.labelOpacity=i[1],e.colorDraft=JXG.rgba2rgbo(this.gEBTN(r,"draft"))[0],e.colorStroke=e.strokeColor,e.colorFill=e.fillColor,e.colorLabel=e.labelColor,e},firstLevelProperties:function(e,t){var i,r,s;if(!JXG.exists(t)||!JXG.exists(t.childNodes))return e;for(s=t.childNodes,i=0;i<s.length;i++)JXG.exists(s[i].firstChild)&&"data"!==s[i].nodeName&&"straight"!==s[i].nodeName&&("width"===(r=s[i].nodeName)&&(r="strokewidth"),e[r]=s[i].firstChild.data);return e},defProperties:function(e,t){return 3===t.nodeType||8===t.nodeType?null:(e.ident=t.nodeName,"text"===e.ident||"intersection"===e.ident||"composition"===e.ident?e.name="":e.name=this.gEBTN(t,"name"),e.id=this.gEBTN(t,"id"),e)},visualProperties:function(e,t){return e.visible=JXG.str2Bool(this.gEBTN(t,"visible")),e.trace=JXG.str2Bool(this.gEBTN(t,"trace")),e},transformProperties:function(e,t){var i,r=["color","dash","style","style","ident","colordraft","colorstroke","colorfill","colorlabel","active","area","showinfo","showcoord","fix"];for(e.strokeWidth=e.strokewidth,e.face=["cross","cross","cross","circle","circle","circle","circle","square","square","square","plus","plus","plus"][parseInt(e.style,10)]||"cross",e.size=[2,3,4,1,2,3,4,2,3,4,2,3,4][parseInt(e.style,10)]||3,e.straightFirst=JXG.str2Bool(e.straightFirst),e.straightLast=JXG.str2Bool(e.straightLast),e.visible=JXG.str2Bool(e.visible),e.draft=JXG.str2Bool(e.draft),e.trace=JXG.str2Bool(e.trace),"point"===t&&(e.fillColor=e.strokeColor,e.highlightFillColor=e.highlightStrokeColor,e.fillOpacity=e.strokeOpacity,e.highlightFillOpacity=e.highlightStrokeOpacity),"string"==typeof e.label&&delete e.label,e.label=e.label||{opacity:e.labelOpacity},i=0;i<r.length;i++)delete e[r[i]];return e},readNodes:function(e,t,i,r){var s,o=this.gEBTN(t,i,0,!1).childNodes;for(s=0;s<o.length;s++)JXG.exists(o[s].firstChild)&&(e[JXG.exists(r)?r+JXG.capitalize(o[s].nodeName):o[s].nodeName]=o[s].firstChild.data);return e},subtreeToString:function(e){try{return(new XMLSerializer).serializeToString(e)}catch(t){return e.xml}},readImage:function(e){var t="",i=e;if(JXG.exists(i))for(t=i.data;JXG.exists(i.nextSibling);)t+=(i=i.nextSibling).data;return t},parseImage:function(e,t,i,r,s,o,a,n){var l,g,d,h,c=null;if(null===t)return c;if(JXG.exists(t.getElementsByTagName("src")[0]))l="src";else{if(!JXG.exists(t.getElementsByTagName("image")[0])||!JXG.exists(this.gEBTN(t,"image")))return c;l="image"}return""!==(d=this.readImage(this.gEBTN(t,l,0,!1).firstChild))?(d="data:image/png;base64,"+d,"src"===l?(r=this.gEBTN(t,"x"),s=this.gEBTN(t,"y"),o=this.gEBTN(t,"width"),a=this.gEBTN(t,"height"),c=e.create("image",[d,[r,s],[o,a]],{anchor:n,layer:i})):((h=new Image).src=d,g=n.id+"_image",h.onload=function(){var t,l,h,c,p,m=this.width,u=this.height;n.elementClass===JXG.OBJECT_CLASS_LINE?(t=function(){return n.point1.X()},h=function(){return n.point1.Dist(n.point2)},c=function(){return h()*u/m},l=function(){return n.point1.Y()-.5*c()},p=e.create("image",[d,[t,l],[h,c]],{layer:i,id:g,anchor:n}),e.create("transform",[function(){return Math.atan2(n.point2.Y()-n.point1.Y(),n.point2.X()-n.point1.X())},n.point1],{type:"rotate"}).bindTo(p),n.image=p):n.elementClass===JXG.OBJECT_CLASS_POINT?(h=function(){return m/e.unitX},c=function(){return u/e.unitY},t=function(){return n.X()-.5*h()},l=function(){return n.Y()-.5*c()},p=e.create("image",[d,[t,l],[h,c]],{layer:i,id:g,anchor:n}),e.renderer.display(n.label,!1),n.image=p):n.elementClass===JXG.OBJECT_CLASS_CIRCLE?(h=function(){return 2*n.Radius()},c=function(){return h()*u/m},t=function(){return n.center.X()-.5*h()},l=function(){return n.center.Y()-.5*c()},p=e.create("image",[d,[t,l],[h,c]],{layer:i,id:g,anchor:n}),n.image=p):(p=e.create("image",[d,[r,s],[o,a]],{layer:i,id:g,anchor:n}),n.image=p)},c)):void 0},readConditions:function(e){var t,i,r="";if(JXG.exists(e))for(t=0;t<e.getElementsByTagName("data").length;t++)i=e.getElementsByTagName("data")[t],r+=this.subtreeToString(i);return r},readViewPort:function(e){var t,i=[];return(t=this.gEBTN(e,"viewport",0,!1))?(i[0]=parseFloat(this.gEBTN(t,"left")),i[1]=parseFloat(this.gEBTN(t,"top")),i[2]=parseFloat(this.gEBTN(t,"right")),i[3]=parseFloat(this.gEBTN(t,"bottom")),i):[]},printDebugMessage:function(e,t,i,r){JXG.debug("* "+r+":  "+i+" "+t.name+" "+t.id)},readNode:function(e,t,i){var r,s,o,a,n,l,g,d,h,c,p,m,u={};if(p=e[t],u=this.defProperties(u,p),JXG.exists(u))switch(this.printDebugMessage("debug",u,p.nodeName.toLowerCase(),"READ:"),p.nodeName.toLowerCase()){case"point":u.strokewidth=1,u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),(u=this.readNodes(u,p,"data")).fixed=JXG.str2Bool(this.gEBTN(p,"fix")),u=this.transformProperties(u,"point"),g=i.create("point",[parseFloat(u.x),parseFloat(u.y)],u),l=this.parseImage(i,p,i.options.layer.image,0,0,0,0,g),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"line":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),u=this.readNodes(u,p,"data"),u=this.readNodes(u,p,"straight","straight"),(u=this.transformProperties(u)).first=this.changeOriginIds(i,u.first),u.last=this.changeOriginIds(i,u.last),o=i.create("line",[u.first,u.last],u),this.parseImage(i,p,i.options.layer.image,0,0,0,0,o),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"circle":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),c=this.gEBTN(p,"data",0,!1),u.center=this.changeOriginIds(i,this.gEBTN(c,"midpoint")),c.getElementsByTagName("radius").length>0?u.radius=this.changeOriginIds(i,this.gEBTN(c,"radius")):c.getElementsByTagName("radiusvalue").length>0&&(u.radius=this.gEBTN(c,"radiusvalue")),u=this.transformProperties(u),a=i.create("circle",[u.center,u.radius],u),this.parseImage(i,p,i.options.layer.image,0,0,0,0,a),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"slider":u.strokewidth=1,u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),(u=this.readNodes(u,p,"data")).fixed=JXG.str2Bool(this.gEBTN(p,"fix")),u=this.readNodes(u,p,"animate","animate"),u=this.transformProperties(u,"point");try{u.parent=this.changeOriginIds(i,u.parent),u.isGeonext=!0,(g=i.create("glider",[parseFloat(u.x),parseFloat(u.y),u.parent],u)).onPolygon=JXG.exists(u.onpolygon)&&JXG.str2Bool(u.onpolygon),this.parseImage(i,p,i.options.layer.point,0,0,0,0,g),this.printDebugMessage("debug",u,p.nodeName,"OK")}catch(e){JXG.debug("* Err:  Slider "+u.name+" "+u.id+": "+u.parent)}break;case"cas":u=this.colorProperties(u,p),u=this.visualProperties(u,p),(u=this.firstLevelProperties(u,p)).fixed=JXG.str2Bool(p.getElementsByTagName("fix")[0].firstChild.data),u=this.readNodes(u,p,"data"),u=this.transformProperties(u,"point"),g=i.create("point",[u.x,u.y],u),this.parseImage(i,p,i.options.layer.point,0,0,0,0,g),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"intersection":u.strokewidth=1,u=this.readNodes(u,p,"data"),m=p.getElementsByTagName("first")[1],u.outFirst={},u.outFirst=this.colorProperties(u.outFirst,m),u.outFirst=this.visualProperties(u.outFirst,m),u.outFirst=this.firstLevelProperties(u.outFirst,m),u.outFirst.fixed=JXG.str2Bool(m.getElementsByTagName("fix")[0].firstChild.data),u.outFirst=this.transformProperties(u.outFirst,"point"),u.first=this.changeOriginIds(i,u.first),u.last=this.changeOriginIds(i,u.last),i.select(u.first).elementClass===JXG.OBJECT_CLASS_LINE&&i.select(u.last).elementClass===JXG.OBJECT_CLASS_LINE?(d=i.create("intersection",[i.objects[u.first],i.objects[u.last],0],u.outFirst),"false"===u.outFirst.visible&&d.hideElement()):(m=p.getElementsByTagName("last")[1],JXG.exists(m)&&(u.outLast={},u.outLast=this.colorProperties(u.outLast,m),u.outLast=this.visualProperties(u.outLast,m),u.outLast=this.firstLevelProperties(u.outLast,m),u.outLast.fixed=JXG.str2Bool(m.getElementsByTagName("fix")[0].firstChild.data),u.outLast=this.transformProperties(u.outLast,"point"),d=i.create("intersection",[i.objects[u.first],i.objects[u.last],0],u.outFirst),d=i.create("intersection",[i.objects[u.first],i.objects[u.last],1],u.outLast))),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"composition":for(u=this.readNodes(u,p,"data"),(u=this.firstLevelProperties(u,p)).defEl=[],n=0,m=p.getElementsByTagName("data")[0].getElementsByTagName("input"),s=0;s<m.length;s++)u.defEl[s]=m[s].firstChild.data,n=s+1;switch(m=p.getElementsByTagName("output")[0],u.out={},u.out=this.colorProperties(u.out,m),u.out=this.visualProperties(u.out,m),u.out=this.firstLevelProperties(u.out,m),u.out=this.transformProperties(u.out),u.defEl[0]=this.changeOriginIds(i,u.defEl[0]),u.defEl[1]=this.changeOriginIds(i,u.defEl[1]),u.defEl[2]=this.changeOriginIds(i,u.defEl[2]),u.type){case"210070":u.out.fixed=this.gEBTN(m,"fix"),m=p.getElementsByTagName("output")[1],u.outPoint={},u.outPoint=this.defProperties(u.outPoint,m),u.outPoint=this.colorProperties(u.outPoint,m),u.outPoint=this.visualProperties(u.outPoint,m),u.outPoint=this.firstLevelProperties(u.outPoint,m),u.outPoint=this.transformProperties(u.outPoint),g=i.create("parallelpoint",[u.defEl[1],u.defEl[0]],u.outPoint),u.out.firstArrow=!1,u.out.lastArrow=!0,(l=i.create("segment",[u.defEl[0],g],u.out)).parallelpoint=g;break;case"210080":u.out.straightFirst=!1,i.create("bisector",[u.defEl[0],u.defEl[1],u.defEl[2]],u.out);break;case"210090":m=p.getElementsByTagName("output")[1],u.outCircle={},u.outCircle=this.defProperties(u.outCircle,m),u.outCircle=this.colorProperties(u.outCircle,m),u.outCircle=this.visualProperties(u.outCircle,m),u.outCircle=this.firstLevelProperties(u.outCircle,m),u.outCircle=this.transformProperties(u.outCircle),u.outCircle.point=u.out,i.create("circumcircle",[u.defEl[0],u.defEl[1],u.defEl[2]],u.outCircle);break;case"210100":i.create("circumcenter",[u.defEl[0],u.defEl[1],u.defEl[2]],u.out);break;case"210110":i.create("midpoint",u.defEl.slice(0,n),u.out);break;case"210120":i.create("reflection",[u.defEl[1],u.defEl[0]],u.out);break;case"210125":i.create("mirrorpoint",[u.defEl[0],u.defEl[1]],u.out);break;case"210130":i.create("perpendicularsegment",[u.defEl[0],u.defEl[1]],u.out);break;case"210140":g=i.create("parallelpoint",[u.defEl[1],u.defEl[0]],{withLabel:!1,visible:!1,name:"",fixed:!0}),(l=i.create("line",[u.defEl[0],g],u.out)).parallelpoint=g;break;case"210150":i.create("parallelpoint",u.defEl.slice(0,n),u.out);break;case"210160":u.out.fixed=this.gEBTN(m,"fix"),m=p.getElementsByTagName("output")[1],u.outLine={},u.outLine=this.defProperties(u.outLine,m),u.outLine=this.colorProperties(u.outLine,m),u.outLine=this.visualProperties(u.outLine,m),u.outLine=this.firstLevelProperties(u.outLine,m),u.outLine=this.readNodes(u.outLine,m,"straight","straight"),u.outLine=this.transformProperties(u.outLine),u.outLine.point=u.out,i.create("perpendicularsegment",[u.defEl[1],u.defEl[0]],u.outLine);break;case"210170":i.create("perpendicularpoint",[u.defEl[1],u.defEl[0]],u.out);break;case"210180":throw new Error("JSXGraph: Element ROTATION not yet implemented.");case"210190":for(u.out=this.defProperties(u.out,m),u.out.firstArrow=JXG.str2Bool(this.gEBTN(m,"firstarrow")),u.out.lastArrow=JXG.str2Bool(this.gEBTN(m,"lastarrow")),m=[],a=[],s=0;s<4;s++)m[s]=p.getElementsByTagName("output")[s],u.out={},u.out=this.defProperties(u.out,m[s]),u.out=this.colorProperties(u.out,m[s]),u.out=this.visualProperties(u.out,m[s]),u.out=this.firstLevelProperties(u.out,m[s]),u.out=this.transformProperties(u.out),a[s]=u.out;l=i.create("sector",u.defEl,a[0]),g=i.create("point",[function(){var e=i.select(u.defEl[1]),t=i.select(u.defEl[2]);return e.X()+(t.X()-e.X())*l.Radius/e.Dist(t)},function(){var e=i.select(u.defEl[1]),t=i.select(u.defEl[2]);return e.Y()+(t.Y()-e.Y())*l.Radius/e.Dist(t)}],a[1]),l=i.create("segment",[u.defEl[0],u.defEl[1]],a[2]),l=i.create("segment",[u.defEl[1],g],a[3]);break;default:throw new Error("JSXGraph: GEONExT -- element "+u.type+" not implemented.")}this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"polygon":for(u=this.colorProperties(u,p),u=this.firstLevelProperties(u,p),r=[],s=0;s<p.getElementsByTagName("data")[0].getElementsByTagName("vertex").length-1;s++)r[s]=p.getElementsByTagName("data")[0].getElementsByTagName("vertex")[s].firstChild.data,r[s]=this.changeOriginIds(i,r[s]);for(u.border=[],u.borders={ids:[],names:[]},s=0;s<p.getElementsByTagName("border").length;s++){u.border[s]={},m=p.getElementsByTagName("border")[s],u.border[s].id=m.getElementsByTagName("id")[0].firstChild.data,u.borders.ids.push(u.border[s].id),u.border[s].name=m.getElementsByTagName("name")[0].firstChild.data,u.borders.names.push(u.border[s].name),u.border[s].straightFirst=JXG.str2Bool(m.getElementsByTagName("straight")[0].getElementsByTagName("first")[0].firstChild.data),u.border[s].straightLast=JXG.str2Bool(m.getElementsByTagName("straight")[0].getElementsByTagName("last")[0].firstChild.data);try{u.border[s].strokeWidth=m.getElementsByTagName("strokewidth")[0].firstChild.data}catch(e){u.border[s].strokeWidth=m.getElementsByTagName("width")[0].firstChild.data}try{u.border[s].dash=JXG.str2Bool(m.getElementsByTagName("dash")[0].firstChild.data)}catch(e){}u.border[s].visible=JXG.str2Bool(m.getElementsByTagName("visible")[0].firstChild.data),u.border[s].draft=JXG.str2Bool(m.getElementsByTagName("draft")[0].firstChild.data),u.border[s].trace=JXG.str2Bool(m.getElementsByTagName("trace")[0].firstChild.data),m=p.getElementsByTagName("border")[s].getElementsByTagName("color")[0],h=JXG.rgba2rgbo(m.getElementsByTagName("stroke")[0].firstChild.data),u.border[s].strokeColor=h[0],u.border[s].strokeOpacity=h[1],h=JXG.rgba2rgbo(m.getElementsByTagName("lighting")[0].firstChild.data),u.border[s].highlightStrokeColor=h[0],u.border[s].highlightStrokeOpacity=h[1],h=JXG.rgba2rgbo(m.getElementsByTagName("fill")[0].firstChild.data),u.border[s].fillColor=h[0],u.border[s].fillOpacity=h[1],u.border[s].highlightFillColor=u.border[s].fillColor,u.border[s].highlightFillOpacity=u.border[s].fillOpacity,u.border[s].labelColor=m.getElementsByTagName("label")[0].firstChild.data,u.border[s].colorDraft=m.getElementsByTagName("draft")[0].firstChild.data}for(u=this.transformProperties(u),g=i.create("polygon",r,u),s=0;s<g.borders.length;s++)g.borders[s].setAttribute(u.border[s]);this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"graph":u=this.colorProperties(u,p),(u=this.firstLevelProperties(u,p)).funct=p.getElementsByTagName("data")[0].getElementsByTagName("function")[0].firstChild.data,u.funct=i.jc.snippet(u.funct,!0,"x",!0),a=i.create("plot",[u.funct],{id:u.id,name:u.name,strokeColor:u.strokeColor,strokeWidth:u.strokeWidth,fillColor:"none",highlightFillColor:"none",highlightStrokeColor:u.highlightStrokeColor,visible:JXG.str2Bool(u.visible)}),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"arrow":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),u=this.readNodes(u,p,"data"),u=this.readNodes(u,p,"straight","straight"),(u=this.transformProperties(u)).first=this.changeOriginIds(i,u.first),u.last=this.changeOriginIds(i,u.last),o=i.create("arrow",[u.first,u.last],u),this.printDebugMessage("debug",o,p.nodeName,"OK");break;case"arc":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),(u=this.readNodes(u,p,"data")).firstArrow=JXG.str2Bool(p.getElementsByTagName("lastarrow")[0].firstChild.data),u.lastArrow=JXG.str2Bool(p.getElementsByTagName("firstarrow")[0].firstChild.data),(u=this.transformProperties(u)).center=this.changeOriginIds(i,u.midpoint),u.angle=this.changeOriginIds(i,u.angle),u.radius=this.changeOriginIds(i,u.radius),a=i.create("arc",[u.center,u.radius,u.angle],u),this.printDebugMessage("debug",a,p.nodeName,"OK");break;case"angle":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),u=this.readNodes(u,p,"data"),(u=this.transformProperties(u)).radius*=1,a=i.create("angle",[u.first,u.middle,u.last],u),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"text":if(u.id.match(/oldVersion/))break;u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),u=this.readNodes(u,p,"data");try{u.mpStr=this.subtreeToString(p.getElementsByTagName("data")[0].getElementsByTagName("mp")[0]),u.mpStr=u.mpStr.replace(/<\/?mp>/g,"")}catch(e){u.mpStr=this.subtreeToString(p.getElementsByTagName("data")[0].getElementsByTagName("content")[0]),u.mpStr=u.mpStr.replace(/<\/?content>/g,"")}u.fixed=!1;try{p.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild&&(u.parent=p.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild.data,u.fixed=!0)}catch(e){}try{u.condition=p.getElementsByTagName("condition")[0].firstChild.data}catch(e){u.condition=""}u.content=p.getElementsByTagName("content")[0].firstChild.data;try{u.fixed=p.getElementsByTagName("fix")[0].firstChild.data}catch(e){u.fixed=!1}try{u.autodigits=p.getElementsByTagName("digits")[0].firstChild.data}catch(e){u.autodigits=2}u.parent=this.changeOriginIds(i,u.parent),a=i.create("text",[parseFloat(u.x),parseFloat(u.y),u.mpStr],{anchor:u.parent,id:u.id,name:u.name,digits:u.autodigits,isLabel:!1,strokeColor:u.colorLabel,fixed:u.fixed,visible:JXG.str2Bool(u.visible)});break;case"parametercurve":u=this.colorProperties(u,p),u=this.visualProperties(u,p),u=this.firstLevelProperties(u,p),(u=this.transformProperties(u)).functionx=p.getElementsByTagName("functionx")[0].firstChild.data,u.functiony=p.getElementsByTagName("functiony")[0].firstChild.data,u.min=p.getElementsByTagName("min")[0].firstChild.data,u.max=p.getElementsByTagName("max")[0].firstChild.data,u.fillColor="none",u.highlightFillColor="none",i.create("curve",[i.jc.snippet(u.functionx,!0,"t",!0),i.jc.snippet(u.functiony,!0,"t",!0),i.jc.snippet(u.min,!0,"",!0),i.jc.snippet(u.max,!0,"",!0)],u),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"tracecurve":u.tracepoint=p.getElementsByTagName("tracepoint")[0].firstChild.data,u.traceslider=p.getElementsByTagName("traceslider")[0].firstChild.data,i.create("tracecurve",[u.traceslider,u.tracepoint],u),this.printDebugMessage("debug",u,p.nodeName,"OK");break;case"group":for(u=this.colorProperties(u,p),(u=this.firstLevelProperties(u,p)).members=[],s=0;s<p.getElementsByTagName("data")[0].getElementsByTagName("member").length;s++)u.members[s]=p.getElementsByTagName("data")[0].getElementsByTagName("member")[s].firstChild.data,u.members[s]=this.changeOriginIds(i,u.members[s]);a=new JXG.Group(i,u.id,u.name,u.members),this.printDebugMessage("debug",u,p.nodeName,"OK");break;default:JXG.debug("* Err: "+p.nodeName+" not yet implemented")}},read:function(){var e,t,i,r,s,o,a=this.tree,n=this.board,l="true";for(n.options.layer.sector=n.options.layer.angle,n.options.layer.circle=n.options.layer.angle,n.options.line.label.position="top",r=this.gEBTN(a,"board",0,!1),s=this.readConditions(r.getElementsByTagName("conditions")[0]),i=this.gEBTN(r,"background",0,!1),i=this.gEBTN(i,"color",0,!0),o=JXG.rgba2rgbo(i),i=JXG.rgbParser(o[0]),n.containerObj.style.backgroundColor="rgba("+i[0]+", "+i[1]+", "+i[2]+", "+o[1]+")",n.attr.takeSizeFromFile&&n.resizeContainer(this.gEBTN(r,"width"),this.gEBTN(r,"height")),e=this.gEBTN(r,"coordinates",0,!1),4===(o=this.readViewPort(e)).length?n.setBoundingBox(o,!0):(o=this.gEBTN(e,"zoom",0,!1),n.zoomX=parseFloat(this.gEBTN(o,"x")),n.zoomY=parseFloat(this.gEBTN(o,"y")),o=this.gEBTN(e,"origin",0,!1),n.origin={usrCoords:[1,0,0],scrCoords:[1,parseFloat(this.gEBTN(o,"x"))*n.zoomX,parseFloat(this.gEBTN(o,"y"))*n.zoomY]},o=this.gEBTN(e,"unit",0,!1),n.unitX=parseFloat(this.gEBTN(o,"x"))*n.zoomX,n.unitY=parseFloat(this.gEBTN(o,"y"))*n.zoomY),n.attr.takeSizeFromFile&&n.resizeContainer(this.gEBTN(r,"width"),this.gEBTN(r,"height")),parseFloat(n.options.text.fontSize)<0&&(n.options.text.fontSize=12),n.geonextCompatibilityMode=!0,delete JXG.boards[n.id],n.id=this.gEBTN(r,"id"),JXG.boards[n.id]=n,n.initGeonextBoard(),n.renderer.enhancedRendering=!0,this.parseImage(n,this.gEBTN(r,"file",0,!1),n.options.layer.image),n.options.point.snapToGrid=this.gEBTN(this.gEBTN(r,"coordinates",0,!1),"snap")===l,n.options.point.snapToGrid&&this.gEBTN(this.gEBTN(r,"grid",1,!1),"pointsnap")===l&&(n.options.point.snapToGrid=!1,n.options.point.snapToPoints=!0,n.options.point.attractorDistance=.5),e=this.gEBTN(r,"grid",1,!1),(o=this.gEBTN(e,"x"))&&(n.options.grid.gridX=1/parseFloat(o),n.options.point.snapSizeX=1/parseFloat(o)),(o=this.gEBTN(e,"y"))&&(n.options.grid.gridY=1/parseFloat(o),n.options.point.snapSizeY=1/parseFloat(o)),n.options.grid.gridDash=JXG.str2Bool(this.gEBTN(e,"dash")),o=JXG.rgba2rgbo(this.gEBTN(e,"color")),n.options.grid.gridColor=o[0],n.options.grid.gridOpacity=o[1],e=this.gEBTN(r,"coordinates",0,!1),this.gEBTN(e,"grid")===l&&n.create("grid",[]),this.gEBTN(e,"coord")===l&&(n.options.axis.ticks.majorHeight=10,n.options.axis.ticks.minorHeight=4,n.create("axis",[[0,0],[1,0]]),n.create("axis",[[0,0],[0,1]])),8===(o=this.gEBTN(this.gEBTN(r,"background",0,!1),"color")).length&&(o="#"+o),n.containerObj.style.backgroundColor=JXG.rgba2rgbo(o)[0],t=a.getElementsByTagName("elements")[0].childNodes,i=0;i<t.length;i++)this.readNode(t,i,n);n.addConditions(s)},decodeString:function(e){var t;return e.indexOf("<GEONEXT>")<0?""===(t=new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(e)).unzip())?e:t:e},prepareString:function(e){try{e.indexOf("GEONEXT")<0&&(e=this.decodeString(e)[0][0]),e=this.fixXML(e)}catch(t){e=""}return e},fixXML:function(e){var t=["active","angle","animate","animated","arc","area","arrow","author","autodigits","axis","back","background","board","border","bottom","buttonsize","cas","circle","color","comment","composition","condition","conditions","content","continuous","control","coord","coordinates","cross","cs","dash","data","description","digits","direction","draft","editable","elements","event","file","fill","first","firstarrow","fix","fontsize","free","full","function","functionx","functiony","GEONEXT","graph","grid","group","height","id","image","info","information","input","intersection","item","jsf","label","last","lastarrow","left","lefttoolbar","lighting","line","loop","max","maximized","member","middle","midpoint","min","modifier","modus","mp","mpx","multi","name","onpolygon","order","origin","output","overline","parametercurve","parent","point","pointsnap","polygon","position","radius","radiusnum","radiusvalue","right","section","selectedlefttoolbar","showconstruction","showcoord","showinfo","showunit","showx","showy","size","slider","snap","speed","src","start","stop","straight","stroke","strokewidth","style","term","text","top","trace","tracecurve","tracepoint","traceslider","type","unit","value","VERSION","vertex","viewport","visible","width","wot","x","xooy","xval","y","yval","zoom"].join("|"),i=new RegExp("&lt;(/?("+t+"))&gt;","g");return e=(e=(e=(e=(e=JXG.escapeHTML(e)).replace(i,"<$1>")).replace(/(<content>.*)<arc>(.*<\/content>)/g,"$1&lt;arc&gt;$2")).replace(/(<mp>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2")).replace(/(<mpx>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2")}}),JXG.registerReader(JXG.GeonextReader,["gxt","geonext"])}();
