/*
    JSXGraph 1.9.1

    Copyright 2008-2024
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(){"use strict";JXG.extendConstants(JXG,{GENTYPE_ABC:1,GENTYPE_AXIS:2,GENTYPE_MID:3,GENTYPE_REFLECTION:4,GENTYPE_MIRRORELEMENT:5,GENTYPE_REFLECTION_ON_LINE:4,GENTYPE_REFLECTION_ON_POINT:5,GENTYPE_TANGENT:6,GENTYPE_PARALLEL:7,GENTYPE_BISECTORLINES:8,GENTYPE_BOARDIMG:9,GENTYPE_BISECTOR:10,GENTYPE_NORMAL:11,GENTYPE_POINT:12,GENTYPE_GLIDER:13,GENTYPE_INTERSECTION:14,GENTYPE_CIRCLE:15,GENTYPE_CIRCLE2POINTS:16,GENTYPE_LINE:17,GENTYPE_TRIANGLE:18,GENTYPE_QUADRILATERAL:19,GENTYPE_TEXT:20,GENTYPE_POLYGON:21,GENTYPE_REGULARPOLYGON:22,GENTYPE_SECTOR:23,GENTYPE_ANGLE:24,GENTYPE_PLOT:25,GENTYPE_SLIDER:26,GENTYPE_TRUNCATE:27,GENTYPE_JCODE:28,GENTYPE_MOVEMENT:29,GENTYPE_COMBINED:30,GENTYPE_RULER:31,GENTYPE_SLOPETRIANGLE:32,GENTYPE_PERPSEGMENT:33,GENTYPE_LABELMOVEMENT:34,GENTYPE_VECTOR:35,GENTYPE_NONREFLEXANGLE:36,GENTYPE_REFLEXANGLE:37,GENTYPE_PATH:38,GENTYPE_DERIVATIVE:39,GENTYPE_DELETE:41,GENTYPE_COPY:42,GENTYPE_MIRROR:43,GENTYPE_ROTATE:44,GENTYPE_ABLATION:45,GENTYPE_MIGRATE:46,GENTYPE_VECTORCOPY:47,GENTYPE_POLYGONCOPY:48,GENTYPE_CTX_TYPE_G:51,GENTYPE_CTX_TYPE_P:52,GENTYPE_CTX_TRACE:53,GENTYPE_CTX_VISIBILITY:54,GENTYPE_CTX_CCVISIBILITY:55,GENTYPE_CTX_MPVISIBILITY:56,GENTYPE_CTX_WITHLABEL:57,GENTYPE_CTX_LABEL:58,GENTYPE_CTX_FIXED:59,GENTYPE_CTX_STROKEWIDTH:60,GENTYPE_CTX_LABELSIZE:61,GENTYPE_CTX_SIZE:62,GENTYPE_CTX_FACE:63,GENTYPE_CTX_STRAIGHT:64,GENTYPE_CTX_ARROW:65,GENTYPE_CTX_COLOR:66,GENTYPE_CTX_RADIUS:67,GENTYPE_CTX_COORDS:68,GENTYPE_CTX_TEXT:69,GENTYPE_CTX_ANGLERADIUS:70,GENTYPE_CTX_DOTVISIBILITY:71,GENTYPE_CTX_FILLOPACITY:72,GENTYPE_CTX_PLOT:73,GENTYPE_CTX_SCALE:74,GENTYPE_CTX_SLIDER_BOUND:75,GENTYPE_CTX_POINT1:76,GENTYPE_CTX_POINT2:77,GENTYPE_CTX_LABELSTICKY:78,GENTYPE_CTX_TYPE_I:79,GENTYPE_CTX_HASINNERPOINTS:80,GENTYPE_CTX_SLIDER_STEP:81,GENTYPE_CTX_SNAPTOGRID:82,GENTYPE_CTX_SNAPTOPOINTS:83,GENTYPE_CTX_STROKEDASH:84,GENTYPE_CTX_SLIDER_VALUE:85,GENTYPE_CTX_SECTORBORDERS:86,GENTYPE_CTX_CURVETAU:87,GENTYPE_CTX_SLIDER_POS:88}),JXG.SketchReader=function(s,e){this.read=function(){var r,i,t,o,a,d;if(o=new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(e)).unzip(),!JXG.exists(o[0]))return"";for(o=JXG.Util.UTF8.decode(o[0][0]),a=(d=jQuery.parseJSON(o)).pop(),i=JXG.exists(a.unredo)?a.unredo:d.length-1,r=0;r<=i;r++)if(0!==d[r].type){try{t=d[r].type>50?JXG.SketchReader.generateJCodeMeta(d[r],s):JXG.SketchReader.generateJCode(d[r],s,d)}catch(s){JXG.debug("#steps: "+d.length),JXG.debug("step: "+r+", type: "+d[r].type),JXG.debug(d[r])}s.jc.parse(t[0],!0)}return t=a.boundingBox,s.jc.parse("$board.setView("+JSON.stringify(t)+");"),""}},JXG.extend(JXG.SketchReader,{generateJCodeMeta:function(){return["","","",""]},id:function(){return JXG.Util.genUUID()},generator:{toFixed:8,freeLine:!1,useGlider:!1,useSymbols:!1},generateJCode:function(s,e,r){var i,t,o,a,d,n,_,l,p,g,c,u,E,G,m,b,T,f,X,P,C,J,O,N,v,h=[],y="",Y="",I="",L="",R=function(s){return X.toFixed>0?(s=parseFloat(s),JXG.toFixed(s,X.toFixed)):s},k=function(s){return X.useSymbols&&e.jc.scope.locals[s]?e.jc.scope.locals[s]:l[s]};if(X=JXG.SketchReader.generator,l=e.objects,P="",C="id: '"+s.dest_id+"', ",JXG.exists(e)&&X.useSymbols&&s.type!==JXG.GENTYPE_ABLATION&&(C="",P=s.dest_id+" = ",JXG.isArray(s.src_ids)))for(i=0;i<s.src_ids.length;i++)(d=e.jc.findSymbol(k(s.src_ids[i]),0)).length>0&&(s.src_ids[i]=d[0]);if(s.type>50)return JXG.SketchReader.generateJCodeMeta(s,e);switch(s.type){case JXG.GENTYPE_TRUNCATE:y="trunclen = "+JXG.Options.trunclen+"; ";break;case JXG.GENTYPE_JCODE:y=s.args.code;break;case JXG.GENTYPE_AXIS:y=s.args.name[0]+" = point("+s.args.coords[0].usrCoords[1]+", ",y+=s.args.coords[0].usrCoords[2]+") <<id: '"+s.dest_sub_ids[0]+"', name: '",y+=s.args.name[0]+"', fixed: true, priv: true, visible: false>>; "+s.args.name[1],y+=" = point("+s.args.coords[1].usrCoords[1]+", ",y+=s.args.coords[1].usrCoords[2]+") <<id: '"+s.dest_sub_ids[1]+"', name: '",y+=s.args.name[1]+"', fixed: true, priv: true, visible: false>>; "+s.args.name[2],y+=" = point("+s.args.coords[2].usrCoords[1]+", ",y+=s.args.coords[2].usrCoords[2]+") <<id: '"+s.dest_sub_ids[2]+"', name: '",y+=s.args.name[2]+"', fixed: true, priv: true, visible: false>>; ",y+=s.args.name[3]+" = axis("+s.args.name[0]+", "+s.args.name[1]+") ",y+="<<id: '"+s.dest_sub_ids[3]+"', name: '"+s.args.name[3]+"', ticks: ",y+="<<minorHeight:0, majorHeight:10, insertTicks: true, ticksDistance: 1, drawLabels: true",y+=', label: <<offset: [-4, -16], parse: false, display: "internal">>',y+=", drawZero: false>>>>; ",y+=s.args.name[4]+" = axis("+s.args.name[0]+", "+s.args.name[2]+") ",y+="<<id: '"+s.dest_sub_ids[4]+"', name: '"+s.args.name[4]+"', ticks: ",y+="<<minorHeight:0, majorHeight:10, insertTicks: true, ticksDistance: 1, drawLabels: true",y+=', label: <<offset: [10, 0], parse: false, display: "internal">>',y+=", drawZero: false>>>>; ",y+=s.dest_sub_ids[3]+".visible = false; ",y+=s.dest_sub_ids[4]+".visible = false; ",Y="remove("+s.dest_sub_ids[4]+"); remove("+s.dest_sub_ids[3],Y+="); remove("+s.dest_sub_ids[2]+"); ",Y+="remove("+s.dest_sub_ids[1]+"); remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_MID:y=P+"midpoint("+s.src_ids[0]+", "+s.src_ids[1]+") <<"+C,y+="fillColor: '"+s.args.fillColor+"'",JXG.exists(s.args.strokeColor)&&(y+=", strokeColor: '"+s.args.strokeColor+"'"),y+=">>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_REFLECTION:case JXG.GENTYPE_REFLECTION_ON_LINE:if("polygon"===s.args.type){for(y="",b=s.src_ids[s.src_ids.length-1],i=1;i<s.src_ids.length-1;i++)y+=P+"reflection("+s.src_ids[i]+", "+b+') <<id:"'+s.dest_sub_ids[i-1]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[i-1]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>;\n";for(J=s.dest_sub_ids.length/2,y+=P+"polygon(",y+=s.dest_sub_ids.slice(0,J).join(),y+=") <<borders: <<ids: ['"+s.dest_sub_ids.slice(J,2*J).join("', '")+"']",O=[],i=0;i<J;i++)O.push("''");y+=", names: ["+O.join()+"]",y+=">>, "+C+" fillOpacity: ",y+=s.args.opacity+", name: '' ",y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,""!==s.args.name&&(y+=', name: "'+s.args.name+'"',y+=", withLabel: true"),y+=", fillColor: '"+s.args.fillColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; "}else if("line"===s.args.type||"vector"===s.args.type){for(y="",b=s.src_ids[s.src_ids.length-1],i=1;i<s.src_ids.length-1;i++)y+=P+"reflection("+s.src_ids[i]+", "+b+') <<id:"'+s.dest_sub_ids[i-1]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[i-1]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>;\n";if("vector"===s.args.type?y+=P+"arrow("+s.dest_sub_ids[0]+","+s.dest_sub_ids[1]+") ":y+=P+"line("+s.dest_sub_ids[0]+","+s.dest_sub_ids[1]+") ",y+="<<",y+=C,y+="strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'",y+=', name: "'+s.args.name+'"',y+=', id: "'+s.dest_id+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=">>; "}else if("circle"===s.args.type){if(y+=P+"reflection("+s.src_ids[0]+","+s.src_ids[2]+") ",y+="<<",y+=C,y+="strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'",y+=', name: "'+s.args.name+'"',y+=', id: "'+s.dest_id+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=', center: <<id:"'+s.dest_sub_ids[0]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[0]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>",y+=">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; "}else{if(y=P+"reflection("+s.src_ids[0]+", "+s.src_ids[1]+") <<"+C,y+="fillColor: '"+s.args.fillColor+"'",JXG.exists(s.args.strokeColor)&&(y+=", strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'"),y+=', name: "'+s.args.name+'"',y+=', id: "'+s.dest_id+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=">>; "}for(Y="",i=0;i<s.dest_sub_ids.length;i++)0!==s.dest_sub_ids[i]&&(Y+="remove("+s.dest_sub_ids[i]+"); ");Y+="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_MIRRORELEMENT:case JXG.GENTYPE_REFLECTION_ON_POINT:if("polygon"===s.args.type){for(y="",b=s.src_ids[s.src_ids.length-1],i=1;i<s.src_ids.length-1;i++)y+=P+"mirrorelement("+s.src_ids[i]+", "+b+') <<id:"'+s.dest_sub_ids[i-1]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[i-1]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>;\n";for(J=s.dest_sub_ids.length/2,y+=P+"polygon(",y+=s.dest_sub_ids.slice(0,J).join(),y+=") <<borders: <<ids: ['"+s.dest_sub_ids.slice(J,2*J).join("', '")+"']",O=[],i=0;i<J;i++)O.push("''");y+=", names: ["+O.join()+"]",y+=">>, "+C+" fillOpacity: ",y+=s.args.opacity+", name: '' ",y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,""!==s.args.name&&(y+=', name: "'+s.args.name+'"',y+=", withLabel: true"),y+=", fillColor: '"+s.args.fillColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; "}else if("line"===s.args.type||"vector"===s.args.type){for(y="",b=s.src_ids[s.src_ids.length-1],i=1;i<s.src_ids.length-1;i++)y+=P+"mirrorelement("+s.src_ids[i]+", "+b+') <<id:"'+s.dest_sub_ids[i-1]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[i-1]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>;\n";if("vector"===s.args.type?y+=P+"arrow("+s.dest_sub_ids[0]+","+s.dest_sub_ids[1]+") ":y+=P+"line("+s.dest_sub_ids[0]+","+s.dest_sub_ids[1]+") ",y+="<<",y+=C,y+="strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'",y+=', name: "'+s.args.name+'"',y+=', id: "'+s.dest_id+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=">>; "}else if("circle"===s.args.type){if(y+=P+"mirrorelement("+s.src_ids[0]+","+s.src_ids[2]+") ",y+="<<",y+=C,y+="strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'",y+=', name: "'+s.args.name+'"',y+=', id: "'+s.dest_id+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=', center: <<id:"'+s.dest_sub_ids[0]+'"',JXG.exists(s.args.subnames)?y+=', name:"'+s.args.subnames[0]+'"':y+=', name: ""',y+=", color: '"+s.args.strokeColor+"'",y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>",y+=">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; "}else{if(y=P+"mirrorelement("+s.src_ids[0]+", "+s.src_ids[1]+") <<"+C,y+="fillColor: '"+s.args.fillColor+"'",JXG.exists(s.args.strokeColor)&&(y+=", strokeColor: '"+s.args.strokeColor+"'",y+=", opacity: '"+s.args.opacity+"'"),y+=', id: "'+s.dest_id+'"',y+=', name: "'+s.args.name+'"',JXG.exists(s.args.attr))for(v in s.args.attr)s.args.attr.hasOwnProperty(v)&&(y+=", "+v+": "+s.args.attr[v]);""!==s.args.name&&(y+=", withLabel: true"),y+=">>; "}for(Y="",i=0;i<s.dest_sub_ids.length;i++)0!==s.dest_sub_ids[i]&&(Y+="remove("+s.dest_sub_ids[i]+"); "+Y);Y+="remove("+s.dest_id+"); "+Y;break;case JXG.GENTYPE_TANGENT:s.args.create_point?(a=s.dest_sub_ids[2],y="point("+R(s.args.usrCoords[1])+","+R(s.args.usrCoords[2])+") <<id: '",y+=a+"', fillColor: '"+s.args.fillColor+"'",JXG.exists(s.args.strokeColor)&&(y+=", strokeColor: '"+s.args.strokeColor+"'"),y+=">>; "+a+".glide(",y+=s.src_ids[0]+"); ",Y="remove("+a+"); "):a=s.src_ids[0],y+=P+"tangent("+a+") <<"+C+"point1: <<name: '",y+="', id: '"+s.dest_sub_ids[0]+"', priv: true>>, point2: <<name: '",y+="', id: '"+s.dest_sub_ids[1]+"', priv: true>> >>; ",Y="remove("+s.dest_sub_ids[0]+"); "+Y,Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[1]+"); "+Y;break;case JXG.GENTYPE_PARALLEL:s.args.create_point?(a=s.dest_sub_ids[1],y="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+") <<id: '",y+=a+"', name: '', visible: false, priv: true>>; ",Y="remove("+a+"); "):a=s.src_ids[1],y+=P+"parallel("+s.src_ids[0]+", "+a+") <<"+C+"name: '', point: <<id: '",y+=s.dest_sub_ids[0]+"', name: ''>> >>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "+Y;break;case JXG.GENTYPE_BISECTORLINES:y=(y="bisectorlines("+s.src_ids[0]+", "+s.src_ids[1]+") <<line1: <<id: '")+s.dest_sub_ids[2]+"', point1: <<id: '"+s.dest_sub_ids[1],y+="', name: ''>>, point2: <<id: '"+s.dest_sub_ids[0],y+="', name: ''>>>>, line2: <<id: '"+s.dest_sub_ids[5],y+="', point1: <<id: '"+s.dest_sub_ids[4]+"', name: '",y+="'>>, point2: <<id: '"+s.dest_sub_ids[3]+"', name: '",y+="'>>>>>>; ",Y="remove("+s.dest_sub_ids[5]+"); remove("+s.dest_sub_ids[4]+"); remove(",Y+=s.dest_sub_ids[3]+"); remove("+s.dest_sub_ids[2]+"); remove(",Y+=s.dest_sub_ids[1]+"); remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_BOARDIMG:y="image('"+s.args.s+"', [ "+s.args.anchor+" ], [ "+s.args.scale+" ]) ",y+="<<id: '"+s.dest_id+"'>>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_BISECTOR:s.args.create_point?(y="",Y="",p=s.dest_sub_ids[1],g=s.dest_sub_ids[2],X.useGlider?(y+="glider("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+", "+s.src_ids[0]+")",y+="<<id: '"+p+"', name:'', withLabel:false, priv:true, visible:false >>; ",y+="glider("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+", "+s.src_ids[1]+")",y+="<<id: '"+g+"', name:'', withLabel:false, priv:true, visible:false >>; "):(y+="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+") ",y+="<<id:'"+p+"', ",y+="name:'', withLabel:false, priv:true, visible:false >>; ",y+=p+".glide("+s.src_ids[0]+"); ",y+="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+") ",y+="<<id:'"+g+"', ",y+="name:'', priv:true, visible:false >>; ",y+=g+".glide("+s.src_ids[1]+"); "),Y+="remove("+p+"); ",Y+="remove("+g+"); ",s.args.create_intersection?(c=s.dest_sub_ids[3],y+="intersection("+s.src_ids[0]+", "+s.src_ids[1]+", 0) ",y+="<<id:'"+c+"', fillColor: '"+s.args.fillColor+"', ",y+="name:'', priv:true, visible:false >>; ",Y+="remove("+c+"); "):c=s.src_ids[2],y+=P+"bisector("+p+", "+c+", "+g+") ",y+="<<"+C+"name: '', point: <<id: '"+s.dest_sub_ids[0]+"', priv: true, name: '",y+=s.dest_sub_ids[0]+"'>> >>;",Y+="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+");"):(y=P+"bisector("+s.src_ids[1]+", "+s.src_ids[2]+", "+s.src_ids[0],y+=") <<"+C+"name: '', point: <<id: '"+s.dest_sub_ids[0]+"', priv: true, name: '",y+=s.dest_sub_ids[0]+"'>>>>;",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+");");break;case JXG.GENTYPE_NORMAL:s.args.create_point?(a=s.dest_sub_ids[1],y="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2]),y+=") <<id: '"+a+"', name: '', visible: false, priv: true>>; ",Y="remove("+a+"); "):a=s.src_ids[1],y+=P+"normal("+a+", "+s.src_ids[0]+") <<"+C,y+="name: '', point: <<id: '"+s.dest_sub_ids[0]+"', name: '",y+="'>> >>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "+Y;break;case JXG.GENTYPE_PERPSEGMENT:y+=P+"perpendicularsegment("+s.src_ids[1]+", "+s.src_ids[0]+") <<"+C,y+="name: '', point: <<id: '"+s.dest_sub_ids[0]+"', name: '",y+="'>> >>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "+Y;break;case JXG.GENTYPE_POINT:y=P+"point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2]),y+=")"+(X.useSymbols?"":" <<id: '"+s.dest_id+"', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+(JXG.exists(s.args.name)?", name: '"+s.args.name+"'":"")+">>")+"; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_GLIDER:X.useGlider?(y=P+"glider("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2]),y+=", "+s.src_ids[0]+")",y+=(X.useSymbols?"":"<<id: '"+s.dest_id+"', snaptogrid: false, snaptopoints: false, snaptopoints: "+JXG.Options.elements.snapToPoints+">>")+";"):(y=P+"point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2]),y+=") <<"+C+"fillColor: '"+JXG.Options.glider.fillColor+"'",y+=", strokeColor: '"+JXG.Options.glider.strokeColor+"'",y+=", snapToGrid: false, snapToPoints: false",y+=">>; "+s.dest_id,y+=".glide("+s.src_ids[0]+"); "),y+=s.dest_id+".onPolygon = "+!!s.args.onPolygon+";",s.args&&s.args.undoIsEmpty||(Y="remove("+s.dest_id+"); ");break;case JXG.GENTYPE_INTERSECTION:y=P+"intersection("+s.src_ids[0]+", "+s.src_ids[1]+", "+s.args.choice,y+=") <<"+C+" fillColor: '"+JXG.Options.intersection.fillColor+"'",y+=", strokeColor: '"+JXG.Options.intersection.strokeColor+"'",y+=">>; ",s.args&&s.args.undoIsEmpty||(Y="remove("+s.dest_id+"); ");break;case JXG.GENTYPE_MIGRATE:var x,A;if(y="$board.migratePoint("+s.src_ids[0]+", "+s.dest_id+", false); ",s.args&&s.args.migrateToGlider)Y=s.dest_id+".free(); "+s.dest_id,Y+=".fillColor = '"+s.args.fillColor+"'; "+s.dest_id,Y+=".strokeColor = '"+s.args.strokeColor+"'; ",Y+="point("+s.args.usrCoords[1]+", "+s.args.usrCoords[2]+")",Y+=" <<id: '"+s.src_ids[0]+"', name: ''>>; ",Y+="$board.migratePoint("+s.dest_id+", "+s.src_ids[0]+", false); ",Y+=s.src_ids[0]+".name = '"+s.args.orig_name+"'; ",Y+=s.src_ids[0]+".label.setText('"+s.args.orig_name+"'); ",A=(x=e.objects[s.dest_id]).slideObject.id,Y+=P+"point("+x.coords.usrCoords[1]+", "+x.coords.usrCoords[2]+") ",Y+="<<"+C+"fillColor: '"+JXG.Options.glider.fillColor+"'>>; ",Y+=s.dest_id+".glide("+A+"); ";break;case JXG.GENTYPE_COMBINED:for(y=Y="",i=0;i<s.args.steps.length;i++)y+=(T=this.generateJCode(s.args.steps[i],e,r))[0],Y=T[2]+Y;break;case JXG.GENTYPE_CIRCLE:var S="name: '', withLabel: true,";s.args.withName&&(S="withLabel: true,"),s.args.create_by_additional_point||s.args.create_point?(JXG.exists(s.args.center_existing)&&s.args.center_existing||(y="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+") ",y+="<<id: '"+s.dest_sub_ids[0]+"', "+S+" visible: true, priv: false>>; "),y+=P+"circle("+s.dest_sub_ids[0]+", "+s.src_ids[0]+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+", hasInnerPoints: true>>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "):s.args.create_by_radius?(y="",JXG.exists(s.args.center_existing)&&s.args.center_existing||(JXG.exists(s.args.x)&&JXG.exists(s.args.y)?y+="point("+R(s.args.x)+", "+R(s.args.y)+") ":y+="point("+R(s.args.usrCoords[1])+", "+R(s.args.usrCoords[2])+") ",y+="<<id: '"+s.dest_sub_ids[0]+"', "+S+" visible: true, priv: false>>; "),JXG.exists(s.args.r)?y+=P+"circle('"+s.dest_sub_ids[0]+"', "+R(s.args.r)+") <<"+C:y+=P+"circle('"+s.dest_sub_ids[0]+"', "+R(s.args.radius)+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+", hasInnerPoints: true>>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "):2===s.src_ids.length?(y="midpoint("+s.src_ids[0]+", "+s.src_ids[1]+")",y+="<<id: '"+s.dest_sub_ids[0]+"', "+S+" visible: true, priv: false>>; ",y+=P+"circle("+s.dest_sub_ids[0]+", "+s.src_ids[0]+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>;",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "):(y=P+"circle("+s.src_ids[0]+", "+s.src_ids[1]+", "+s.src_ids[2],y+=") <<center: <<id: '"+s.dest_sub_ids[0]+"', "+S,y+=" visible: true>>, "+C+"name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); ");break;case JXG.GENTYPE_CIRCLE2POINTS:s.args.create_two_points?(y="point("+R(s.args.x1)+", "+R(s.args.y1)+") <<id: '"+s.dest_sub_ids[0],y+="'>>; ",y+="point("+R(s.args.x2)+", "+R(s.args.y2)+") <<id: '",y+=s.dest_sub_ids[1]+"'>>; ",y+=P+"circle("+s.dest_sub_ids[0]+", "+s.dest_sub_ids[1]+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[1]+"); remove(",Y+=s.dest_sub_ids[0]+"); "):s.args.create_point?(y="point("+R(s.args.x)+", "+R(s.args.y)+") <<id: '"+s.dest_sub_ids[0],y+="'>>; ",y+=P+"circle("+s.dest_sub_ids[0]+", "+s.src_ids[0]+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); remove("+s.dest_sub_ids[0]+"); "):s.args.create_by_radius?(y=P+"circle("+s.src_ids[0]+", "+s.args.r+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); "):(y=P+"circle("+s.src_ids[0]+", "+s.src_ids[1]+") <<"+C,y+="name: '', fillOpacity: "+JXG.Options.opacityLevel+", snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); ");break;case JXG.GENTYPE_LINE:if(o=0,t=0,s.args.create_point1){for(p=s.dest_sub_ids[o],o+=1,n=[],i=0;i<s.args.p1.length;i++)n[i]=R(s.args.p1[i]);y="point("+n.join(", ")+") <<id: '"+p+"', name: '', visible: false, isinfinit: true, ",y+="snaptogrid: false, snaptopoints: false, priv: true>>; ",Y="remove("+p+"); "}else p=s.src_ids[t],t+=1;if(s.args.create_point2){for(g=s.dest_sub_ids[o++],n=[],i=0;i<s.args.p2.length;i++)n[i]=R(s.args.p2[i]);y+="point("+n.join(", ")+") <<id: '"+g+"', name: '', visible: false, isinfinit: true, ",y+="snaptogrid: false, snaptopoints: false, priv: true>>; ",Y="remove("+g+"); "+Y}else g=s.src_ids[t],t+=1;if(d="line",n="",_=p+", "+g,s.args.create_point1&&s.args.create_point2&&X.freeLine){for(y="",Y="",2===s.args.p1.length&&s.args.p1.unshift(1),2===s.args.p2.length&&s.args.p2.unshift(1),_=JXG.Math.crossProduct(s.args.p1,s.args.p2),i=0;i<_.length;i++)_[i]=R(_[i]);_=_.join(", ")}s.args.first||s.args.last?(s.args.first||(n="straightFirst: "+s.args.first),s.args.last||(n="straightLast: "+s.args.last),n.length>0&&!X.useSymbols&&(n+=", ")):d="segment",X.useSymbols||(C="id: '"+s.dest_id+"'"),y+=P+d+"("+_+")",n.length+C.length>0?y+=" <<"+n+C+", name: '', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ":y+=" <<name: '', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); "+Y;break;case JXG.GENTYPE_VECTOR:if(o=0,t=0,s.args.create_point1){for(p=s.dest_sub_ids[o],o+=1,n=[],i=0;i<s.args.p1.length;i++)n[i]=R(s.args.p1[i]);y="point("+n.join(", ")+") <<id: '"+p+"', name: '', visible: true, ",y+="snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: false, priv: false>>; ",Y="remove("+p+"); "}else p=s.src_ids[t],t+=1;if(s.args.create_point2){for(g=s.dest_sub_ids[o++],n=[],i=0;i<s.args.p2.length;i++)n[i]=R(s.args.p2[i]);y+="point("+n.join(", ")+") <<id: '"+g+"', name: '', visible: true, ",y+="layer: "+JXG.Options.layer.line+", opacity: 0.2, ",y+="snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: false, priv: false>>; ",Y="remove("+g+"); "+Y}else g=s.src_ids[t],t+=1;n="",_=p+", "+g,d="arrow",X.useSymbols||(C="id: '"+s.dest_id+"'"),y+=P+d+"("+_+")",n.length+C.length>0?y+=" <<"+n+C+", name: '', strokeColor: 'black', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ":y+=" <<name: '', strokeColor: 'black', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",Y="remove("+s.dest_id+"); "+Y;break;case JXG.GENTYPE_TRIANGLE:for(i=0;i<s.args.create_point.length;i++)s.args.create_point[i]&&(y+="point("+R(s.args.coords[i].usrCoords[1])+", ",y+=R(s.args.coords[i].usrCoords[2])+") <<id: '"+s.dest_sub_ids[i],y+="', snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ");for(i=0;i<s.dest_sub_ids.length;i++)0!==s.dest_sub_ids[i]&&(Y="remove("+s.dest_sub_ids[i]+"); "+Y);if(Y="remove("+s.dest_id+"); "+Y,y+=P+"polygon(",3===s.src_ids.length)for(i=0;i<s.src_ids.length;i++)y+=s.src_ids[i],i<s.src_ids.length-1&&(y+=", ");else for(i=0;i<3;i++)0!==s.dest_sub_ids[i]&&((s.src_ids.length>0||i>0)&&(y+=", "),y+=s.dest_sub_ids[i]);y+=") <<borders: <<ids: ['"+s.dest_sub_ids[3]+"', '"+s.dest_sub_ids[4]+"', '"+s.dest_sub_ids[5]+"']",y+=", names: ['', '', '']",y+=">>, "+C+" fillOpacity: ",y+=JXG.Options.opacityLevel+", name: '' ",y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ";break;case JXG.GENTYPE_QUADRILATERAL:for(i=0;i<s.args.create_point.length;i++)s.args.create_point[i]&&(y+="point("+R(s.args.coords[i].usrCoords[1])+", ",y+=R(s.args.coords[i].usrCoords[2])+") <<id: '"+s.dest_sub_ids[i],y+="', snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ");for(i=0;i<s.dest_sub_ids.length;i++)0!==s.dest_sub_ids[i]&&(Y="remove("+s.dest_sub_ids[i]+"); "+Y);for(Y="remove("+s.dest_id+"); "+Y,y+=P+"polygon(",i=0;i<s.src_ids.length;i++)y+=s.src_ids[i],i<s.src_ids.length-1&&(y+=", ");y+=") <<borders: <<ids: [ '"+s.dest_sub_ids[4]+"', '"+s.dest_sub_ids[5],y+="', '",y+=s.dest_sub_ids[6]+"', '"+s.dest_sub_ids[7]+"' ]",y+=", names: ['', '', '', '']",y+=">>, "+C,y+=" fillOpacity: ",y+=JXG.Options.opacityLevel+", name: '' ",y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,y+=", snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ";break;case JXG.GENTYPE_TEXT:"'"!==s.args.str.slice(0,1)&&'"'!==s.args.str.slice(0,1)&&"function"!==s.args.str.slice(0,8)&&(s.args.str="'"+s.args.str+"'"),y=P+"text("+R(s.args.x)+", "+R(s.args.y)+", "+s.args.str+") <<",y+=C+"name: ''",void 0!==s.args.anchor&&(y+=", anchor: "+s.args.anchor),y+=">>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_RULER:y=P+"tapemeasure([ "+s.args.p1+" ], [ "+s.args.p2+" ]) <<",y+=C+"name: '', precision: "+JXG.Options.trunclen+", point1: <<id: '"+s.dest_sub_ids[0]+"', snaptogrid: "+JXG.Options.elements.snapToGrid+">>, point2: <<id: '"+s.dest_sub_ids[1]+"', snaptogrid: "+JXG.Options.elements.snapToGrid+">> >>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_POLYGON:if(s.args.create_point)for(i=0;i<s.args.create_point.length;i++)s.args.create_point[i]&&(y+="point("+R(s.args.coords[i].usrCoords[1])+", ",y+=R(s.args.coords[i].usrCoords[2])+") <<id: '"+s.dest_sub_ids[i],y+="', snaptogrid: "+JXG.Options.elements.snapToGrid,y+=", snaptopoints: "+JXG.Options.elements.snapToPoints+">>; ");if(s.dest_sub_ids)for(i=0;i<s.dest_sub_ids.length;i++)0!==s.dest_sub_ids[i]&&(Y="remove("+s.dest_sub_ids[i]+"); "+Y);for(Y="remove("+s.dest_id+"); "+Y,y+=P+"polygon(",i=0;i<s.src_ids.length;i++)y+=s.src_ids[i],i!==s.src_ids.length-1&&(y+=", ");for(y+=") <<borders: <<ids: ['",i=0;i<s.dest_sub_ids.length;i++)y+=s.dest_sub_ids[i],i<s.dest_sub_ids.length-1&&(y+="', '");for(y+="']",y+=", names: [",i=0;i<s.dest_sub_ids.length;i++)y+="''",i<s.dest_sub_ids.length-1&&(y+=", ");y+="]",y+=">>, "+C+" fillOpacity: "+JXG.Options.opacityLevel,y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,y+=", name: ''>>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_POLYGONCOPY:for(J=s.args.num_vertices,y="",Y="",i=0;i<J;++i)y+=P+"point("+R(s.args.points[i][1])+", "+R(s.args.points[i][2]),y+=")"+(X.useSymbols?"":" <<id: '"+s.dest_sub_ids[i]+"', snaptogrid: "+JXG.Options.elements.snapToGrid+", snaptopoints: "+JXG.Options.elements.snapToPoints+">>")+"; ",Y+="remove("+s.dest_sub_ids[i]+"); ";for(y+=P+"polygon(",i=0;i<J;++i)y+=s.dest_sub_ids[i],i!==J-1&&(y+=", ");for(y+=") <<borders: <<ids: ['",i=J;i<s.dest_sub_ids.length;i++)y+=s.dest_sub_ids[i],i<s.dest_sub_ids.length-1&&(y+="', '");for(y+="']",y+=", names: [",i=J;i<s.dest_sub_ids.length;i++)y+="''",i<s.dest_sub_ids.length-1&&(y+=", ");y+="]",y+=">>, "+C+" fillOpacity: "+JXG.Options.opacityLevel,y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,y+=", name: ''>>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ",Y+="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_REGULARPOLYGON:for(y=P+"regularpolygon("+s.src_ids.join(", ")+", ",y+=s.args.corners+") <<borders: <<ids: [ ",i=0;i<s.args.corners;i++)y+="'"+s.dest_sub_ids[i]+"'",i!==s.args.corners-1&&(y+=", "),Y="remove("+s.dest_sub_ids[i]+"); "+Y;for(y+="]",y+=", names: [",i=0;i<s.args.corners;i++)y+="''",i<s.args.corners-1&&(y+=", ");for(y+="]",y+=">>, vertices: <<ids: [ ",i=0;i<s.args.corners-2;i++)y+="'"+s.dest_sub_ids[i+parseInt(s.args.corners,10)]+"'",i!==s.args.corners-3&&(y+=", "),Y="remove("+s.dest_sub_ids[i+parseInt(s.args.corners,10)]+"); "+Y;y+=" ]",y+=", name: ''",y+=">>, "+C,y+=" fillOpacity: "+JXG.Options.opacityLevel,y+=", hasInnerPoints: "+JXG.Options.polygon.hasInnerPoints,y+=", name: ''>>; ",y+=s.dest_id+".hasInnerPoints = function() { return !("+s.dest_id+".fillColor == 'transparent' || "+s.dest_id+".fillColor == 'none' || "+s.dest_id+".fillOpacity == 0); }; ",Y="remove("+s.dest_id+"); "+Y;break;case JXG.GENTYPE_SECTOR:y=P,p=s.dest_id,g=s.dest_sub_ids[0],c=p+(s.args.suffix_glider??"_glider"),u=p+(s.args.suffix_segment1??"_segment1"),E=p+(s.args.suffix_segment2??"_segment2"),y+="sector("+s.src_ids.join(", ")+") ",y+="<<"+C+" name: '', fillOpacity: "+JXG.Options.opacityLevel+", hasInnerPoints: true, arc: <<id: '"+g+"', priv:true>> >>; ",y+=p+".hasInnerPoints = function() { return !("+p+".fillColor == 'transparent' || "+p+".fillColor == 'none' || "+p+".fillOpacity == 0); }; ",y+="glider(function () { return "+s.src_ids[2]+".X(); }, function () { return "+s.src_ids[2]+".Y(); }, "+g+") ",y+="<<id: '"+c+"', name:'', parents: ['"+p+"', '"+g+"', '"+s.src_ids[2]+"'], priv:true>>; ",y+="segment("+s.src_ids[0]+", "+s.src_ids[1]+") ",y+="<<id: '"+u+"', name:'', parents: ['"+p+"', '"+s.src_ids[0]+"', '"+s.src_ids[1]+"'], priv:true>>; ",y+="segment("+s.src_ids[0]+", "+c+") ",y+="<<id: '"+E+"', name:'', parents: ['"+p+"', '"+s.src_ids[0]+"', '"+c+"'], priv:true>>; ",Y="",Y+="remove("+c+"); ",Y+="remove("+u+"); ",Y+="remove("+E+"); ",Y+="remove("+p+"); ";break;case JXG.GENTYPE_ANGLE:y=P+"angle("+s.src_ids.join(", ")+") ",y+="<<",y+="dot: <<priv:true, id: '"+s.dest_sub_ids[0]+"', name: ''>>, ",y+=C+" fillOpacity: "+JXG.Options.opacityLevel,JXG.exists(s.args)&&JXG.exists(s.args.radius)&&(JXG.isNumber(s.args.radius)?y+=", radius: "+s.args.radius:y+=", radius: '"+s.args.radius+"'"),y+=", hasInnerPoints: true>>; ",Y="remove("+s.dest_id+"); ",Y+="remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_NONREFLEXANGLE:y=P+"nonreflexangle("+s.src_ids.join(", ")+") ",y+="<<",y+="dot: <<priv:true, id: '"+s.dest_sub_ids[0]+"', ",y+="name: ''>>, ",y+=C+" fillOpacity: "+JXG.Options.opacityLevel,JXG.exists(s.args)&&JXG.exists(s.args.radius)&&(JXG.isNumber(s.args.radius)?y+=", radius: "+s.args.radius:y+=", radius: '"+s.args.radius+"'"),y+=">>; ",Y="remove("+s.dest_id+"); ",Y+="remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_REFLEXANGLE:y=P+"reflexangle("+s.src_ids.join(", ")+") ",y+="<<",y+="dot: <<priv:true, id: '"+s.dest_sub_ids[0]+"', ",y+="name: ''>>, ",y+=C+" fillOpacity: "+JXG.Options.opacityLevel,JXG.exists(s.args)&&JXG.exists(s.args.radius)&&(JXG.isNumber(s.args.radius)?y+=", radius: "+s.args.radius:y+=", radius: '"+s.args.radius+"'"),y+=">>; ",Y="remove("+s.dest_id+"); ",Y+="remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_SLOPETRIANGLE:y=P+"slopetriangle("+s.src_ids.join(", ")+") <<",y+=C+" name: '',",y+="borders:   <<ids: ['"+s.dest_sub_ids[4]+"', '"+s.dest_sub_ids[5]+"', '"+s.dest_sub_ids[6]+"']>>,",y+="basepoint: <<id: '"+s.dest_sub_ids[0]+"', name: '', priv: true >>, ",y+="baseline:  <<id: '"+s.dest_sub_ids[1]+"', name: '', priv: true >>,",y+="glider:    <<id: '"+s.dest_sub_ids[2]+"', name: '', priv: false >>, ",y+="toppoint:  <<id: '"+s.dest_sub_ids[3]+"', name: '', priv: false >>",8===s.dest_sub_ids.length&&(y+=", tangent: <<id: '"+s.dest_sub_ids[7]+"', priv: true, point1: <<name: '', priv: true >>, point2: <<name: '', priv: true >> >>"),y+=">>;",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_PLOT:y=P+s.args.plot_type+"("+s.args.func,(isNaN(s.args.a)||null===s.args.a||void 0===s.args.a||"-infinity"===s.args.a)&&(s.args.a=""),(isNaN(s.args.b)||null===s.args.b||void 0===s.args.b||"infinity"===s.args.b)&&(s.args.b=""),s.args.a!=s.args.b&&(y+=", "+s.args.a+", "+s.args.b),y+=") <<",s.args.isPolar&&(y+="curveType: 'polar', "),y+=C+"name: '', withLabel: true, strokeColor: '"+s.args.color+"', doAdvancedPlot: true, doAdvancedPlotOld: false >>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_PATH:for(J=s.args.points.length,y+=P+"cardinalspline([",i=0;i<s.args.points.length;i++)JXG.isString(s.args.points[i])?y+="'"+s.args.points[i]+"'":(3===s.args.points[i].length?(O=s.args.points[i][1].toPrecision(4),N=s.args.points[i][2].toPrecision(4)):(O=s.args.points[i][0].toPrecision(4),N=s.args.points[i][1].toPrecision(4)),y+="["+O+","+N+"]"),i<J-1&&(y+=",");y+="], function() {    o = $('"+s.dest_id+"');    if(o) {      return o.tau;    } else {      return 1;    }}, "+s.args.type,y+=") <<",y+=C+"name: '', withLabel: false, tau: "+s.args.tau+", ",y+="fixed: false, ",s.args.createPoints||(y+="createPoints: false, "),y+="isArrayOfCoordinates: true, ",y+="strokeWidth: "+s.args.strokeWidth+", ",y+="strokeColor: '"+s.args.strokeColor+"' >>; ",Y="remove("+s.dest_id+"); ";break;case JXG.GENTYPE_DERIVATIVE:y=P+"derivative("+s.src_ids+")",y+=" <<",y+="dash: 2",y+=" >>;";break;case JXG.GENTYPE_SLIDER:y=P+"slider(["+R(s.args.x1)+", "+R(s.args.y1)+"], ["+R(s.args.x2)+", "+R(s.args.y2)+"], ["+R(s.args.min??s.args.start)+", "+R(s.args.start??s.args.ini)+", "+R(s.args.max??s.args.end)+"]) ",y+="<<"+C,y+=" snapWidth: "+R(s.args.step??"0.1")+", ",y+="baseline: <<id: '"+s.dest_sub_ids[0]+"', name: ''>>, ",y+="highline: <<id: '"+s.dest_sub_ids[1]+"', name: ''>>, ",y+="point1: <<id: '"+s.dest_sub_ids[2]+"', name: ''>>, ",y+="point2: <<id: '"+s.dest_sub_ids[3]+"', name: ''>>, ",y+="label: <<id: '"+s.dest_sub_ids[4]+"', name: '', priv: true>>",y+=", name: '"+s.args.name+"'>>; ",Y="remove("+s.dest_id+"); ",Y+="remove("+s.dest_sub_ids[4]+"); ",Y+="remove("+s.dest_sub_ids[3]+"); ",Y+="remove("+s.dest_sub_ids[2]+"); ",Y+="remove("+s.dest_sub_ids[1]+"); ",Y+="remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_DELETE:for(T=[],I=[],L=[],i=0;i<s.args.steps.length;i++)(T=r[s.args.steps[i]].type>50?this.generateJCodeMeta(r[s.args.steps[i]],e):this.generateJCode(r[s.args.steps[i]],e,r)).length>=3&&""!==JXG.trim(T[2])&&(y=T[2]+y),T.length>=4&&JXG.isFunction(T[3])&&I.unshift(T[3]),T.length>=1&&""!==JXG.trim(T[0])&&(Y+=T[0]),T.length>=2&&JXG.isFunction(T[1])&&L.push(T[1]);break;case JXG.GENTYPE_COPY:for(b in h=[],s.args.steps)if(s.args.steps.hasOwnProperty(b)){if((f=JXG.deepCopy(r[s.args.steps[b]])).type===JXG.GENTYPE_COPY){for(i=0;i<f.args.map.length;i++)for(t=0;t<s.args.map.length;t++)f.args.map[i].copy===s.args.map[t].orig&&(f.args.map[i].copy=s.args.map[t].copy);f=JXG.SketchReader.replaceStepDestIds(f,f.args.map)}else f=JXG.SketchReader.replaceStepDestIds(f,s.args.map);h.push(f)}for(i=0;i<h.length;i++)T=h[i].type>50?this.generateJCodeMeta(h[i],e):this.generateJCode(h[i],e,r),""!==JXG.trim(T[0])&&(y+=T[0]),JXG.isFunction(T[1])&&I.push(T[1]),""!==JXG.trim(T[2])&&(Y=T[2]+Y),JXG.isFunction(T[3])&&L.unshift(T[3]);if(s.args.dep_copy)for(i=0;i<s.args.map.length;i++)k(s.args.map[i].orig).elementClass===JXG.OBJECT_CLASS_POINT&&(y+=s.args.map[i].copy,y+=".X = function() { return ("+s.args.map[i].orig+".X() - ",y+=R(s.args.x)+"); }; ",y+=s.args.map[i].copy,y+=".Y = function() { return ("+s.args.map[i].orig+".Y() - ",y+=R(s.args.y)+"); }; ");else for(i=0;i<s.args.free_points.length;i++)G=k(s.args.free_points[i].orig).coords.usrCoords[1],m=k(s.args.free_points[i].orig).coords.usrCoords[2],y+=s.args.free_points[i].copy+".X = function() { return ",y+=R(G-s.args.x)+"; }; ",y+=s.args.free_points[i].copy+".Y = function() { return ",y+=R(m-s.args.y)+"; }; ",y+=s.args.free_points[i].copy+".free(); ";for(t=0;t<s.args.map.length;t++)(b=k(s.args.map[t].orig)).type!==JXG.OBJECT_TYPE_CIRCLE||JXG.exists(b.point2)||(y+=s.args.map[t].copy+".setRadius(function () { return ",y+=s.args.map[t].orig+".radius(); }); ");break;case JXG.GENTYPE_ABLATION:for(G=k(s.src_ids[0]).coords.usrCoords[1],m=k(s.src_ids[0]).coords.usrCoords[2],y="point("+R(G-s.args.x)+", "+R(m-s.args.y)+") <<id: '",y+=s.dest_sub_ids[0]+"', name: '', withLabel: false>>; ",y+="circle('"+s.dest_sub_ids[0]+"', 1) <<id: '"+s.dest_sub_ids[1],y+="', fillOpacity: "+JXG.Options.opacityLevel,y+=", strokeColor: '#888888', visible: true, name: '', withLabel: false>>; ",1===s.args.fids.length?s.args.func=s.args.fids[0]+".radius()":s.args.func="dist("+s.args.fids[0]+", "+s.args.fids[1]+")",y+=s.dest_sub_ids[1]+".setRadius(function() { return "+s.args.func+"; }); ",t=0;t<s.src_ids.length;t++)y+=s.src_ids[t]+".addChild("+s.dest_sub_ids[0]+"); ",y+=s.src_ids[t]+".addChild("+s.dest_sub_ids[1]+"); ";0!==s.args.migrate&&-1!==s.args.migrate&&(y+="$board.migratePoint("+s.dest_sub_ids[0]+", "+s.args.migrate+"); "),Y="remove("+s.dest_sub_ids[1]+"); remove("+s.dest_sub_ids[0]+"); ";break;case JXG.GENTYPE_VECTORCOPY:for(G=k(s.src_ids[0]).coords.usrCoords[1],m=k(s.src_ids[0]).coords.usrCoords[2],y="point("+R(G-s.args.x)+", "+R(m-s.args.y)+") <<id: '",y+=s.dest_sub_ids[0]+"', name: '', withLabel: false>>; ",y+="parallelpoint('"+s.src_ids[0]+"','"+s.src_ids[1]+"','"+s.dest_sub_ids[0]+"') <<id: '"+s.dest_sub_ids[1],y+="', strokeColor: '#888888', visible: true, priv: false, name: '', ",y+="layer: "+JXG.Options.layer.line+", opacity: 0.2, withLabel: false>>; ",y+="arrow('"+s.dest_sub_ids[0]+"','"+s.dest_sub_ids[1]+"') <<id: '"+s.dest_sub_ids[2],y+="', strokeColor: '#888888', visible: true, name: '', withLabel: false>>; ",t=0;t<s.src_ids.length;t++)y+=s.src_ids[t]+".addChild("+s.dest_sub_ids[0]+"); ",y+=s.src_ids[t]+".addChild("+s.dest_sub_ids[1]+"); ",y+=s.src_ids[t]+".addChild("+s.dest_sub_ids[2]+"); ";0!==s.args.migrate&&-1!==s.args.migrate&&(y+="$board.migratePoint("+s.dest_sub_ids[0]+", "+s.args.migrate+"); "),Y="remove("+s.dest_sub_ids[1]+"); remove("+s.dest_sub_ids[0]+"); remove("+s.dest_sub_ids[2]+");";break;case JXG.GENTYPE_MOVEMENT:if(s.args.obj_type===JXG.OBJECT_TYPE_LINE||s.args.obj_type===JXG.OBJECT_TYPE_VECTOR)y=s.src_ids[0]+".move(["+R(s.args.coords[0].usrCoords[0])+", ",y+=R(s.args.coords[0].usrCoords[1])+", "+R(s.args.coords[0].usrCoords[2])+"]); ",Y=s.src_ids[0]+".move(["+s.args.zstart[0]+", "+s.args.xstart[0]+", ",Y+=s.args.ystart[0]+"]); ",y+=s.src_ids[1]+".move(["+R(s.args.coords[1].usrCoords[0])+", ",y+=R(s.args.coords[1].usrCoords[1])+", "+R(s.args.coords[1].usrCoords[2])+"]); ",Y+=s.src_ids[1]+".move(["+s.args.zstart[1]+", "+s.args.xstart[1]+", ",Y+=s.args.ystart[1]+"]); ";else if(s.args.obj_type===JXG.OBJECT_TYPE_CIRCLE)y=s.src_ids[0]+".move(["+R(s.args.coords[0].usrCoords[1])+", ",y+=R(s.args.coords[0].usrCoords[2])+"]); ",Y=s.src_ids[0]+".move(["+s.args.xstart+", "+s.args.ystart+"]); ",s.args.has_point2&&(y+=s.src_ids[1]+".move(["+R(s.args.coords[1].usrCoords[1])+", ",y+=R(s.args.coords[1].usrCoords[2])+"]); ",Y+=s.src_ids[1]+".move(["+s.args.old_p2x+", "+s.args.old_p2y,Y+="]); ");else if(s.args.obj_type===JXG.OBJECT_TYPE_POLYGON)for(y=Y="",i=0;i<s.src_ids.length;i++)y+=s.src_ids[i]+".move(["+R(s.args.coords[i].usrCoords[1])+", ",y+=R(s.args.coords[i].usrCoords[2])+"]); ",Y+=s.src_ids[i]+".move(["+s.args.xstart[i]+", "+s.args.ystart[i],Y+="]); ";else JXG.exists(s.args.coords[0])&&(y=s.src_ids[0]+".move(["+R(s.args.coords[0].usrCoords[1])+", ",y+=R(s.args.coords[0].usrCoords[2])+"]); ",Y=s.src_ids[0]+".move(["+s.args.xstart+", "+s.args.ystart+"]); ");break;default:return JXG.debug("No such GENTYPE!"+s.type),[]}return[y,I,Y,L]},replaceStepDestIds:function(s,e){var r,i,t=[];for(r=0;r<e.length;r++){for(t.push(e[r].copy),s.dest_id===e[r].orig&&(s.dest_id=e[r].copy),i=0;i<s.dest_sub_ids.length;i++)s.dest_sub_ids[i]===e[r].orig&&(s.dest_sub_ids[i]=e[r].copy);for(i=0;i<s.src_ids.length;i++)s.src_ids[i]===e[r].orig&&(s.src_ids[i]=e[r].copy)}for(i=0;i<s.dest_sub_ids.length;i++)JXG.isInArray(t,s.dest_sub_ids[i])||(s.dest_sub_ids[i]=this.id());return s.src_ids=JXG.uniqueArray(s.src_ids),s.dest_sub_ids=JXG.uniqueArray(s.dest_sub_ids),s}}),JXG.registerReader(JXG.SketchReader,["sketch","sketchometry"])}();
