/*
    JSXGraph 1.9.1

    Copyright 2008-2024
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(){"use strict";JXG.GeogebraReader=function(e,t){var r,s;s=this.prepareString(t),r=JXG.XML.parse(s),this.tree=r,this.board=e,this.ggbElements=[],this.board.ggb={},this.format=parseFloat(r.getElementsByTagName("geogebra")[0].getAttribute("format")),this.decimals=parseInt(r.getElementsByTagName("geogebra")[0].getElementsByTagName("kernel")[0].getElementsByTagName("decimals")[0].getAttribute("val"),10)},JXG.extend(JXG.GeogebraReader.prototype,{ggbAct:function(e,t,r){var s,a,i,o=new RegExp("JXG\\.boards\\['"+this.board.id+'\'\\].select\\("(.+?)"\\)\\.'),n=new RegExp("JXG\\.boards\\['"+this.board.id+"'\\].select"),c=t,l=r;switch(e.toLowerCase()){case"end":case"param":case"html":return c;case"coord":return[s=this.ggbElements[c]?"JXG.boards['"+this.board.id+"'].select('"+c+"')":c,a=this.ggbElements[l]?"JXG.boards['"+this.board.id+"'].select('"+l+"')":l];case"le":return"( ("+c+") <= ("+l+") )";case"ge":return"( ("+c+") >= ("+l+") )";case"eq":return"( ("+c+") == ("+l+") )";case"neq":return"( ("+c+") != ("+l+") )";case"lt":return"( ("+c+") < ("+l+") )";case"gt":return"( ("+c+") > ("+l+") )";case"add":return this.isGGBVector(c)&&this.isGGBVector(l)?[1,c[1]+"+"+l[1],c[2]+"+"+l[2]]:(s=JXG.isString(c)&&!c.match(o)&&c.match(n)?[c+".X()",c+".Y()"]:c,a=JXG.isString(l)&&!l.match(o)&&l.match(n)?[l+".X()",l+".Y()"]:l,this.isGGBVector(s)&&JXG.isArray(a)?[s[1]+"+"+a[0],s[2]+"+"+a[1]]:this.isGGBVector(a)&&JXG.isArray(s)?[a[1]+"+"+s[0],a[2]+"+"+s[1]]:JXG.isArray(s)&&JXG.isArray(a)?[s[0]+" + "+a[0],s[1]+" + "+a[1]]:(JXG.isNumber(s)||JXG.isString(s))&&(JXG.isNumber(a)||JXG.isString(a))?s+" + "+a:(JXG.isNumber(s)||JXG.isString(s))&&JXG.isArray(a)?[s+" + "+a[0],s+" + "+a[1]]:JXG.isArray(s)&&(JXG.isNumber(a)||JXG.isString(a))?[s[0]+" + "+a,s[1]+" + "+a]:s+" + "+a);case"sub":return this.isGGBVector(c)&&this.isGGBVector(l)?[1,c[1]+"-"+l[1],c[2]+"-"+l[2]]:(s=JXG.isString(c)&&!c.match(o)&&c.match(n)?[c+".X()",c+".Y()"]:c,a=JXG.isString(l)&&!l.match(o)&&l.match(n)?[l+".X()",l+".Y()"]:l,this.isGGBVector(s)&&JXG.isArray(a)?[s[1]+"-"+a[0],s[2]+"-"+a[1]]:JXG.isArray(s)&&this.isGGBVector(a)?[s[0]+"-("+a[1]+")",s[1]+"-("+a[2]+")"]:JXG.isArray(s)&&JXG.isArray(a)?[s[0]+" - "+a[0],s[1]+" - "+a[1]]:(JXG.isNumber(s)||JXG.isString(s))&&(JXG.isNumber(a)||JXG.isString(a))?s+" - "+a:(JXG.isNumber(s)||JXG.isString(s))&&JXG.isArray(a)?[s+" - "+a[0],s+" - "+a[1]]:JXG.isArray(s)&&(JXG.isNumber(a)||JXG.isString(a))?[s[0]+" - "+a,s[1]+" - "+a]:s+" - "+a);case"neg":return"!("+c+")";case"pow":return"Math.pow("+c+", "+l+")";case"or":return"("+c+"||"+l+")";case"and":return"("+c+"&&"+l+")";case"mul":return this.isGGBVector(c)&&!JXG.isArray(l)?[1,"("+c[1]+")*"+l,"("+c[2]+")*"+l]:!JXG.isArray(c)&&this.isGGBVector(l)?[1,"("+l[1]+")*"+c,"("+l[2]+")*"+c]:this.isGGBVector(c)&&this.isGGBVector(l)?"(("+c[1]+")*("+l[1]+")+("+c[2]+")*("+l[2]+"))":(s=JXG.isString(c)&&!c.match(o)&&c.match(n)?[c+".X()",c+".Y()"]:c,a=JXG.isString(l)&&!l.match(o)&&l.match(n)?[l+".X()",l+".Y()"]:l,JXG.isArray(s)&&JXG.isArray(a)?[s[0]+" * "+a[0],s[1]+" * "+a[1]]:(JXG.isNumber(s)||JXG.isString(s))&&(JXG.isNumber(a)||JXG.isString(a))?s+" * "+a:(JXG.isNumber(s)||JXG.isString(s))&&JXG.isArray(a)?[s+" * "+a[0],s+" * "+a[1]]:JXG.isArray(s)&&(JXG.isNumber(a)||JXG.isString(a))?[s[0]+" * "+a,s[1]+" * "+a]:s+" * "+a);case"div":return s=JXG.isString(c)&&!c.match(o)&&c.match(n)?[c+".X()",c+".Y()"]:c,a=JXG.isString(l)&&!l.match(o)&&l.match(n)?[l+".X()",l+".Y()"]:l,JXG.isArray(s)&&JXG.isArray(a)?[s[0]+" / "+a[0],s[1]+" / "+a[1]]:(JXG.isNumber(s)||JXG.isString(s))&&(JXG.isNumber(a)||JXG.isString(a))?s+" / "+a:(JXG.isNumber(s)||JXG.isString(s))&&JXG.isArray(a)?[s+" / "+a[0],s+" / "+a[1]]:JXG.isArray(s)&&(JXG.isNumber(a)||JXG.isString(a))?[s[0]+" / "+a,s[1]+" / "+a]:s+" / "+a;case"negmult":return this.isGGBVector(c)?[1,"-1*"+c[1],"-1*"+c[2]]:"-1*"+c;case"bra":return this.isGGBVector(c)?[1,"("+c[1]+")","("+c[2]+")"]:"("+c+")";case"int":return parseInt(c,10);case"float":return parseFloat(c);case"string":return l?[c,l]:c;case"command":if(s=(l=c.split("["))[0],a=l[1].split("]")[0],"name"===s.toLowerCase())return"JXG.boards['"+this.board.id+"'].select('"+a+"').getName()";break;case"var":if(!l)return"PI"===c?"Math.PI":(i=this.checkElement(c),JXG.exists(this.board.ggb[c])?"JXG.boards['"+this.board.id+"'].ggb[\""+c+'"]()':JXG.exists(i.Value)?"JXG.boards['"+this.board.id+"'].select(\""+c+'").Value()':JXG.exists(i.Area)?"JXG.boards['"+this.board.id+"'].select(\""+c+'").Area()':JXG.exists(i.plaintextStr)?"1.0*JXG.boards['"+this.board.id+"'].select(\""+c+'").plaintextStr':i.type===JXG.OBJECT_TYPE_VECTOR?[1,"JXG.boards['"+this.board.id+"'].select(\""+c+"\").point2.X()-JXG.boards['"+this.board.id+"'].select(\""+c+'").point1.X()',"JXG.boards['"+this.board.id+"'].select(\""+c+"\").point2.Y()-JXG.boards['"+this.board.id+"'].select(\""+c+'").point1.Y()']:i.elementClass===JXG.OBJECT_CLASS_LINE?"JXG.boards['"+this.board.id+"'].select(\""+c+"\").point1.Dist(JXG.boards['"+this.board.id+"'].select(\""+c+'").point2)':"JXG.boards['"+this.board.id+"'].select(\""+c+'")');switch(c.toLowerCase()){case"x":return l+".X()";case"y":return l+".Y()";case"abs":case"acos":case"asin":case"atan":case"ceil":case"cos":case"exp":case"floor":case"log":case"max":case"min":case"pow":case"random":case"round":case"sin":case"sqrt":case"tan":return"Math."+c.toLowerCase()+"("+l+")";default:return c.toLowerCase()+"*("+l+")"}}},ggbParse:function(e,t){var r,s,a=[],i=[],o="",n=e,c=!1,l=this,h=!!t&&this.board.select(this.ggbElements[t].id);function g(e){var t=0,r=-1,s=0,a=0,i=e.offset+1;do{if(t=0,r=-2,a=i-=1,e.src.length<=a)return 28;do{switch(t){case 0:t=9===e.src.charCodeAt(i)||32===e.src.charCodeAt(i)?1:33===e.src.charCodeAt(i)?2:40===e.src.charCodeAt(i)?3:41===e.src.charCodeAt(i)?4:42===e.src.charCodeAt(i)?5:43===e.src.charCodeAt(i)?6:44===e.src.charCodeAt(i)?7:45===e.src.charCodeAt(i)?8:47===e.src.charCodeAt(i)?9:e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57?10:60===e.src.charCodeAt(i)?11:62===e.src.charCodeAt(i)?12:e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?13:94===e.src.charCodeAt(i)?14:34===e.src.charCodeAt(i)?26:38===e.src.charCodeAt(i)?28:46===e.src.charCodeAt(i)?29:61===e.src.charCodeAt(i)?30:95===e.src.charCodeAt(i)?31:124===e.src.charCodeAt(i)?32:-1;break;case 1:t=-1,r=1,s=i;break;case 2:t=61===e.src.charCodeAt(i)?15:-1,r=23,s=i;break;case 3:t=-1,r=2,s=i;break;case 4:t=-1,r=3,s=i;break;case 5:t=-1,r=13,s=i;break;case 6:t=-1,r=11,s=i;break;case 7:t=-1,r=16,s=i;break;case 8:t=-1,r=12,s=i;break;case 9:t=-1,r=14,s=i;break;case 10:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57?10:46===e.src.charCodeAt(i)?18:-1,r=4,s=i;break;case 11:t=61===e.src.charCodeAt(i)?19:-1,r=21,s=i;break;case 12:t=61===e.src.charCodeAt(i)?21:-1,r=22,s=i;break;case 13:t=e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?13:e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57?27:91===e.src.charCodeAt(i)?34:95===e.src.charCodeAt(i)?35:-1,r=7,s=i;break;case 14:t=-1,r=15,s=i;break;case 15:t=-1,r=20,s=i;break;case 16:t=-1,r=9,s=i;break;case 17:t=-1,r=25,s=i;break;case 18:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57?18:-1,r=5,s=i;break;case 19:t=-1,r=17,s=i;break;case 20:t=-1,r=19,s=i;break;case 21:t=-1,r=18,s=i;break;case 22:t=-1,r=24,s=i;break;case 23:t=-1,r=8,s=i;break;case 24:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57||e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?24:-1,r=6,s=i;break;case 25:t=-1,r=10,s=i;break;case 26:t=34===e.src.charCodeAt(i)?16:32===e.src.charCodeAt(i)||46===e.src.charCodeAt(i)||e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57||61===e.src.charCodeAt(i)||e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122||223===e.src.charCodeAt(i)||228===e.src.charCodeAt(i)||246===e.src.charCodeAt(i)||252===e.src.charCodeAt(i)?26:-1;break;case 27:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57||e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?27:95===e.src.charCodeAt(i)?35:-1,r=7,s=i;break;case 28:t=38===e.src.charCodeAt(i)?17:e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?33:-1;break;case 29:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57?18:-1;break;case 30:t=61===e.src.charCodeAt(i)?20:-1;break;case 31:t=95===e.src.charCodeAt(i)?36:-1;break;case 32:t=124===e.src.charCodeAt(i)?22:-1;break;case 33:t=59===e.src.charCodeAt(i)?23:e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?33:-1;break;case 34:t=e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?37:-1;break;case 35:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57||e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?27:95===e.src.charCodeAt(i)?35:-1;break;case 36:t=e.src.charCodeAt(i)>=48&&e.src.charCodeAt(i)<=57||e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?24:-1;break;case 37:t=93===e.src.charCodeAt(i)?25:e.src.charCodeAt(i)>=65&&e.src.charCodeAt(i)<=90||e.src.charCodeAt(i)>=97&&e.src.charCodeAt(i)<=122?37:-1}i+=1}while(t>-1)}while(1===r);return r>-1?(e.att=e.src.substr(a,s-a),e.offset=s):(e.att="",r=-1),r}if(h&&JXG.debug("Update element: "+h.name+"("+h.id+")"),(s=function(e,t,r){var s,a,i,o,b,d,u,m,p,G,A,y=[],C=[],X=0,f={};for(p=[[0,1],[27,1],[26,5],[26,3],[26,3],[26,3],[26,3],[26,3],[26,3],[26,3],[26,3],[26,2],[26,3],[26,3],[26,3],[26,3],[26,3],[26,2],[26,3],[26,3],[26,1],[26,1],[26,1],[26,1],[26,1],[26,1],[26,4],[26,1]],m=[[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[28,0],[14,13,13,14,25,15,24,16,15,17,12,18,11,19,22,20,21,21,20,22,19,23,18,24,17,25,28,-1],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[11,29,28,-24,17,-24,18,-24,19,-24,20,-24,21,-24,22,-24,12,-24,15,-24,24,-24,25,-24,13,-24,14,-24,16,-24,3,-24],[28,-20,17,-20,18,-20,19,-20,20,-20,21,-20,22,-20,11,-20,12,-20,15,-20,24,-20,25,-20,13,-20,14,-20,16,-20,3,-20],[28,-21,17,-21,18,-21,19,-21,20,-21,21,-21,22,-21,11,-21,12,-21,15,-21,24,-21,25,-21,13,-21,14,-21,16,-21,3,-21],[28,-22,17,-22,18,-22,19,-22,20,-22,21,-22,22,-22,11,-22,12,-22,15,-22,24,-22,25,-22,13,-22,14,-22,16,-22,3,-22],[28,-23,17,-23,18,-23,19,-23,20,-23,21,-23,22,-23,11,-23,12,-23,15,-23,24,-23,25,-23,13,-23,14,-23,16,-23,3,-23],[28,-25,17,-25,18,-25,19,-25,20,-25,21,-25,22,-25,11,-25,12,-25,15,-25,24,-25,25,-25,13,-25,14,-25,16,-25,3,-25],[2,30,28,-27,17,-27,18,-27,19,-27,20,-27,21,-27,22,-27,11,-27,12,-27,15,-27,24,-27,25,-27,13,-27,14,-27,16,-27,3,-27],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[14,13,13,14,25,15,24,16,15,17,12,18,11,19,22,20,21,21,20,22,19,23,18,24,17,25,16,44,3,45],[14,-11,13,-11,25,15,24,16,15,-11,12,-11,11,-11,22,-11,21,-11,20,-11,19,-11,18,-11,17,-11,28,-11,16,-11,3,-11],[14,-17,13,-17,25,15,24,16,15,17,12,-17,11,-17,22,20,21,21,20,22,19,23,18,24,17,25,28,-17,16,-17,3,-17],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[14,-16,13,-16,25,15,24,16,15,17,12,-16,11,-16,22,20,21,21,20,22,19,23,18,24,17,25,28,-16,16,-16,3,-16],[14,-15,13,-15,25,15,24,16,15,17,12,-15,11,-15,22,20,21,21,20,22,19,23,18,24,17,25,28,-15,16,-15,3,-15],[14,-14,13,-14,25,-14,24,-14,15,-14,12,-14,11,-14,22,-14,21,-14,20,-14,19,-14,18,-14,17,-14,28,-14,16,-14,3,-14],[14,-13,13,-13,25,-13,24,-13,15,-13,12,-13,11,-13,22,-13,21,-13,20,-13,19,-13,18,-13,17,-13,28,-13,16,-13,3,-13],[14,-12,13,-12,25,15,24,16,15,-12,12,-12,11,-12,22,20,21,21,20,22,19,23,18,24,17,25,28,-12,16,-12,3,-12],[14,13,13,14,25,15,24,16,15,17,12,-10,11,-10,22,20,21,21,20,22,19,23,18,24,17,25,28,-10,16,-10,3,-10],[14,13,13,14,25,15,24,16,15,17,12,-9,11,-9,22,20,21,21,20,22,19,23,18,24,17,25,28,-9,16,-9,3,-9],[14,-8,13,-8,25,15,24,16,15,-8,12,-8,11,-8,22,-8,21,-8,20,-8,19,-8,18,-8,17,-8,28,-8,16,-8,3,-8],[14,-7,13,-7,25,15,24,16,15,-7,12,-7,11,-7,22,-7,21,-7,20,-7,19,-7,18,-7,17,-7,28,-7,16,-7,3,-7],[14,-6,13,-6,25,15,24,16,15,-6,12,-6,11,-6,22,-6,21,-6,20,-6,19,-6,18,-6,17,-6,28,-6,16,-6,3,-6],[14,-5,13,-5,25,15,24,16,15,-5,12,-5,11,-5,22,-5,21,-5,20,-5,19,-5,18,-5,17,-5,28,-5,16,-5,3,-5],[14,-4,13,-4,25,15,24,16,15,-4,12,-4,11,-4,22,-4,21,-4,20,-4,19,-4,18,-4,17,-4,28,-4,16,-4,3,-4],[14,-3,13,-3,25,15,24,16,15,-3,12,-3,11,-3,22,-3,21,-3,20,-3,19,-3,18,-3,17,-3,28,-3,16,-3,3,-3],[2,3,23,4,12,5,9,6,4,7,5,8,6,9,8,10,10,11,7,12],[28,-18,17,-18,18,-18,19,-18,20,-18,21,-18,22,-18,11,-18,12,-18,15,-18,24,-18,25,-18,13,-18,14,-18,16,-18,3,-18],[14,13,13,14,25,15,24,16,15,17,12,-19,11,-19,22,20,21,21,20,22,19,23,18,24,17,25,28,-19,16,-19,3,-19],[14,13,13,14,25,15,24,16,15,17,12,18,11,19,22,20,21,21,20,22,19,23,18,24,17,25,3,49],[14,13,13,14,25,15,24,16,15,17,12,18,11,19,22,20,21,21,20,22,19,23,18,24,17,25,3,50],[28,-26,17,-26,18,-26,19,-26,20,-26,21,-26,22,-26,11,-26,12,-26,15,-26,24,-26,25,-26,13,-26,14,-26,16,-26,3,-26],[28,-2,17,-2,18,-2,19,-2,20,-2,21,-2,22,-2,11,-2,12,-2,15,-2,24,-2,25,-2,13,-2,14,-2,16,-2,3,-2]],G=[[27,1,26,2],[],[],[26,26],[26,27],[26,28],[],[],[],[],[],[],[],[26,31],[26,32],[26,33],[26,34],[26,35],[26,36],[26,37],[26,38],[26,39],[26,40],[26,41],[26,42],[26,43],[],[],[],[26,46],[26,47],[],[],[],[],[],[],[],[],[],[],[],[],[],[26,48],[],[],[],[],[],[]],A=["p'","WHITESPACE","(",")","INT","FLOAT","PARAM","VAR","HTML","STRING","COMMAND","+","-","*","/","^",",","<=",">=","==","!=","<",">","!","||","&&","e","p","$$"],f.offset=0,f.src=e,f.att="",t||(t=[]),r||(r=[]),y.push(0),C.push(0),o=g(f);;){for(a=52,s=0;s<m[y[y.length-1]].length;s+=2)if(m[y[y.length-1]][s]===o){a=m[y[y.length-1]][s+1];break}if(52===a){for(X+=1,t.push(f.offset-f.att.length),r.push([]),s=0;s<m[y[y.length-1]].length;s+=2)r[r.length-1].push(A[m[y[y.length-1]][s]]);for(u=[],d=[],s=0;s<y.length;s++)u[s]=y[s],d[s]=C[s];for(;52===a&&28!==o;){for(c,-1===o&&(f.offset+=1);52===a&&y.length>0&&(y.pop(),C.pop(),0!==y.length);)for(a=52,s=0;s<m[y[y.length-1]].length;s+=2)if(m[y[y.length-1]][s]===o){a=m[y[y.length-1]][s+1];break}if(52!==a)break;for(s=0;s<u.length;s++)y.push(u[s]),C.push(d[s]);o=g(f)}if(52===a){c;break}c}if(a>0)y.push(a),C.push(f.att),o=g(f);else{switch(b=undefined,a*=-1){case 0:b=C[C.length-1];break;case 1:b=l.ggbAct("end",C[C.length-1]);break;case 2:b=l.ggbAct("coord",C[C.length-4],C[C.length-2],h);break;case 3:b=l.ggbAct("le",C[C.length-3],C[C.length-1]);break;case 4:b=l.ggbAct("ge",C[C.length-3],C[C.length-1]);break;case 5:b=l.ggbAct("eq",C[C.length-3],C[C.length-1]);break;case 6:b=l.ggbAct("neq",C[C.length-3],C[C.length-1]);break;case 7:b=l.ggbAct("lt",C[C.length-3],C[C.length-1]);break;case 8:b=l.ggbAct("gt",C[C.length-3],C[C.length-1]);break;case 9:b=l.ggbAct("add",C[C.length-3],C[C.length-1]);break;case 10:b=l.ggbAct("sub",C[C.length-3],C[C.length-1]);break;case 11:b=l.ggbAct("neg",C[C.length-1]);break;case 12:b=l.ggbAct("pow",C[C.length-3],C[C.length-1]);break;case 13:b=l.ggbAct("or",C[C.length-3],C[C.length-1]);break;case 14:b=l.ggbAct("and",C[C.length-3],C[C.length-1]);break;case 15:b=l.ggbAct("mul",C[C.length-3],C[C.length-1]);break;case 16:b=l.ggbAct("div",C[C.length-3],C[C.length-1]);break;case 17:b=l.ggbAct("negmult",C[C.length-1]);break;case 18:b=l.ggbAct("bra",C[C.length-2]);break;case 19:b=l.ggbAct("string",C[C.length-3],C[C.length-1]);break;case 20:b=l.ggbAct("int",C[C.length-1]);break;case 21:b=l.ggbAct("float",C[C.length-1]);break;case 22:b=l.ggbAct("param",C[C.length-1]);break;case 23:b=l.ggbAct("html",C[C.length-1]);break;case 24:b=l.ggbAct("string",C[C.length-1]);break;case 25:b=l.ggbAct("command",C[C.length-1]);break;case 26:b=l.ggbAct("var",C[C.length-4],C[C.length-2]);break;case 27:b=l.ggbAct("var",C[C.length-1])}for(s=0;s<p[a][1];s++)y.pop(),n=C.pop();for(i=-1,s=0;s<G[y[y.length-1]].length;s+=2)if(G[y[y.length-1]][s]===p[a][0]){i=G[y[y.length-1]][s+1];break}if(0===a)break;c,y.push(i),C.push(b)}c}return X}(n,a,i))>0){for(r=0;r<s;r++)o+="Parse error in line "+(n.substr(0,a[r]).match(/\n/g)?n.substr(0,a[r]).match(/\n/g).length:1)+" near '"+n.substr(a[r])+"', expecting '"+i[r].join()+"'\n";JXG.debug(o)}return n},setDefaultOptions:function(){this.board.options.elements.strokeWidth=1,this.board.options.elements.withLabel=!0,this.board.options.point.face="circle",this.board.options.point.size=3,this.board.options.point.fillColor="blue",this.board.options.point.fillOpacity=1,this.board.options.point.highlightFillOpacity=1,this.board.options.point.strokeColor="black",this.board.options.point.highlightStrokeColor="black",this.board.options.point.strokeWidth=2,this.board.options.line.strokeWidth=1,this.board.options.line.highlightStrokeColor="#000000",this.board.options.line.strokeColor="#000000",this.board.options.polygon.fillColor=JXG.rgb2hex(153,51,0),this.board.options.polygon.fillOpacity=.1,this.board.options.polygon.highlightFillColor=this.board.options.polygon.fillColor,this.board.options.polygon.highlightFillOpacity=.1,this.board.options.sector.fillColor=JXG.rgb2hex(153,51,0),this.board.options.sector.fillOpacity=.1,this.board.options.sector.highlightFillColor=this.board.options.sector.fillColor,this.board.options.sector.highlightFillOpacity=.1,this.board.options.angle.fillColor=JXG.rgb2hex(0,100,0),this.board.options.angle.fillOpacity=.1,this.board.options.angle.highlightFillOpacity=.1},colorProperties:function(e,t){var r,s,a,i,o=e.getElementsByTagName("objColor")[0],n=e.getElementsByTagName("objColor").length>0;return r=n&&o.getAttribute("alpha")?parseFloat(o.getAttribute("alpha")):0,s=n&&o.getAttribute("r")?parseInt(o.getAttribute("r"),10).toString(16):0,a=n&&o.getAttribute("g")?parseInt(o.getAttribute("g"),10).toString(16):0,i=n&&o.getAttribute("b")?parseInt(o.getAttribute("b"),10).toString(16):0,1===s.length&&(s="0"+s),1===a.length&&(a="0"+a),1===i.length&&(i="0"+i),t.fillColor="#"+s+a+i,t.strokeColor=t.fillColor,t.highlightFillColor=t.fillColor,t.highlightStrokeColor=t.strokeColor,t.fillOpacity=r,t.highlightFillOpacity=r,t.labelColor=t.fillColor,t},boardProperties:function(e,t,r){return r},coordinates:function(e,t){var r,s,a={x:0,y:0,z:0};if(t.getElementsByTagName("labelOffset")[0]&&(a.x=parseFloat(t.getElementsByTagName("labelOffset")[0].getAttribute("x"))/this.board.unitX,a.y=parseFloat(t.getElementsByTagName("labelOffset")[0].getAttribute("y"))/this.board.unitY),t.getElementsByTagName("coords")[0])e.x=parseFloat(t.getElementsByTagName("coords")[0].getAttribute("x")),e.y=parseFloat(t.getElementsByTagName("coords")[0].getAttribute("y")),e.z=parseFloat(t.getElementsByTagName("coords")[0].getAttribute("z"));else if(t.getElementsByTagName("startPoint")[0])t.getElementsByTagName("startPoint")[0].getAttribute("exp")?(r=this.board.select(t.getElementsByTagName("startPoint")[0].getAttribute("exp")),e.x=function(){return r.X()+a.x},e.y=function(){return r.Y()-a.y},e.z=!1):(e.x=parseFloat(t.getElementsByTagName("startPoint")[0].getAttribute("x")),e.y=parseFloat(t.getElementsByTagName("startPoint")[0].getAttribute("y")),e.z=parseFloat(t.getElementsByTagName("startPoint")[0].getAttribute("z")));else{if(!t.getElementsByTagName("absoluteScreenLocation")[0])return!1;s=new JXG.Coords(JXG.COORDS_BY_SCREEN,[parseFloat(t.getElementsByTagName("absoluteScreenLocation")[0].getAttribute("x")),parseFloat(t.getElementsByTagName("absoluteScreenLocation")[0].getAttribute("y"))],this.board),e.x=s.usrCoords[1]+a.x,e.y=s.usrCoords[2]+a.y,e.z=!1}return e},visualProperties:function(e,t){var r=e.getElementsByTagName("show"),s=e.getElementsByTagName("pointSize"),a=e.getElementsByTagName("pointStyle"),i=e.getElementsByTagName("slopeTriangleSize"),o=e.getElementsByTagName("lineStyle"),n=e.getElementsByTagName("labelOffset"),c=e.getElementsByTagName("trace"),l=e.getElementsByTagName("fix");return r.length>0&&r[0].getAttribute("object")&&(t.visible=JXG.str2Bool(r[0].getAttribute("object"))),r.length>0&&r[0].getAttribute("label")&&(t.withLabel=JXG.str2Bool(r[0].getAttribute("label"))),s.length>0&&s[0].getAttribute("val")&&(t.size=parseInt(s[0].getAttribute("val"),10)),a.length>0&&a[0].getAttribute("val")&&(t.styleGGB=parseInt(a[0].getAttribute("val"),10)),0===t.styleGGB||2===t.styleGGB?(t.face="circle",0===t.styleGGB?(t.fillColor=t.strokeColor,t.fillOpacity=1,t.highlightFillColor=t.strokeColor,t.highlightFillOpacity=1,t.strokeColor="black",t.strokeWidth=1):2===t.styleGGB&&(t.fillColor="none")):1===t.styleGGB?t.face="x":3===t.styleGGB?(t.face="+",t.strokeOpacity=1):4===t.styleGGB||5===t.styleGGB?(t.face="diamond",4===t.styleGGB?(t.fillColor=t.strokeColor,t.fillOpacity=1):5===t.styleGGB&&(t.fillColor="none")):6===t.styleGGB?(t.face="triangleUp",t.fillColor=t.strokeColor,t.fillOpacity=1):7===t.styleGGB?(t.face="triangleDown",t.fillColor=t.strokeColor,t.fillOpacity=1):8===t.styleGGB?(t.face="triangleRight",t.fillColor=t.strokeColor,t.fillOpacity=1):9===t.styleGGB&&(t.face="triangleLeft",t.fillColor=t.strokeColor,t.fillOpacity=1),i.length>0&&(t.slopeWidth=i[0].getAttribute("val")),o.length>0&&(t.strokeWidth=Math.round(parseFloat(o[0].getAttribute("thickness"))/2),t.dashGGB=o[0].getAttribute("type")),t.strokeWidth&&(t.highlightStrokeWidth=t.strokeWidth+1),"0"===t.dashGGB?t.dash=0:"10"===t.dashGGB?t.dash=2:"15"===t.dashGGB?t.dash=3:"20"===t.dashGGB?t.dash=1:"30"===t.dashGGB&&(t.dash=6),n.length>0&&(t.labelX=parseFloat(n[0].getAttribute("x")),t.labelY=parseFloat(n[0].getAttribute("y"))),c.length>0&&(t.trace=c[0].getAttribute("val")),l.length>0&&(t.fixed=l[0].getAttribute("val")),t},getElement:function(e,t){var r,s,a;for(t=t||!1,s=0;s<this.tree.getElementsByTagName("construction").length;s++)if(!1===t){for(a=0;a<this.tree.getElementsByTagName("construction")[s].getElementsByTagName("element").length;a++)if(e===(r=this.tree.getElementsByTagName("construction")[s].getElementsByTagName("element")[a]).getAttribute("label"))return r}else for(a=0;a<this.tree.getElementsByTagName("construction")[s].getElementsByTagName("expression").length;a++){if(e===(r=this.tree.getElementsByTagName("construction")[s].getElementsByTagName("expression")[a]).getAttribute("label"))return r;if(e===r.getAttribute("exp"))return this.getElement(r.getAttribute("label"))}return!1},checkElement:function(e){var t;if(!JXG.exists(this.ggbElements[e])||""===this.ggbElements[e]){if(!(t=this.getElement(e)||this.getElement(e,!0))){var r,s,a,i=this.ggbParse(e);for(r=0;r<this.tree.getElementsByTagName("construction").length;r++)for(s=0;s<this.tree.getElementsByTagName("construction")[r].getElementsByTagName("expression").length;s++){a=this.tree.getElementsByTagName("construction")[r].getElementsByTagName("expression")[s];var o=this.ggbParse(a.getAttribute("exp"));JXG.isArray(i)&&JXG.isArray(o)&&i[0]==o[0]&&i[1]==o[1]&&(t=this.getElement(a.getAttribute("label")))}if(!t)return new Function("return "+i+";")}this.ggbElements[e]=this.writeElement(t)}return this.ggbElements[e]},functionParse:function(e,t){var r,s,a,i,o,n;switch(e){case"c":if(t.match(/[a-zA-Z0-9\']+\([a-zA-Z0-9]+[a-zA-Z0-9,\ ]*\)[\ ]*[=][\ ]*[a-zA-Z0-9\+\-\*\/ \( \) \u005E]+/)){for(r=t.split("(")[1].split(")")[0].split(", "),a=[],i=0;i<r.length;i++)a.push("__"+r[i]);for(s=t.split("=")[1],i=0;i<r.length;i++)s="x"===r[i]?s.replace(/(?![e])x(?!\()(?![p])/g,"__"+r[i]):"y"===r[i]?s.replace(/(?![e])y(?!\()(?![p])/g,"__"+r[i]):s.replace(new RegExp(r[i],"g"),"__"+r[i]);if(s=s.replace(/-__/g,"-1*__"),this.format<=3.01){for(o=s.split(" "),n="",i=0;i<o.length;i++)o.length!==i+1&&(o[i].search(/\)$/)>-1||o[i].search(/[0-9]+$/)>-1||o[i].search(/[a-zA-Z]+(_*[a-zA-Z0-9]+)*$/)>-1)&&(o[i+1].search(/^\(/)>-1||o[i+1].search(/^[0-9]+/)>-1||o[i+1].search(/^[a-zA-Z]+(_*[a-zA-Z0-9]+)*/)>-1||o[i+1].search(/__[a-zA-Z0-9]+/)>-1)&&(o[i]=o[i]+"*"),n+=o[i];s=n}return a.push(s),a}return t;case"s":return["__x",t=t.replace(/(?![e])x(?!\()(?![p])/g,"__x")];default:if(this.format<=3.01){for(o=t.split(" "),n="",i=0;i<o.length;i++)o.length!==i+1&&(o[i].search(/\)$/)>-1||o[i].search(/[0-9]+$/)>-1||o[i].search(/[a-zA-Z]+(_*[a-zA-Z0-9]+)*$/)>-1)&&(o[i+1].search(/^\(/)>-1||o[i+1].search(/^[0-9]+/)>-1||o[i+1].search(/^[a-zA-Z]+(\_*[a-zA-Z0-9]+)*/)>-1||o[i+1].search(/\_\_[a-zA-Z0-9]+/)>-1)&&(o[i]=o[i]+"*"),n+=o[i];t=n}return t}},writeBoard:function(){var e=this.tree.getElementsByTagName("euclidianView")[0],t=e.getElementsByTagName("coordSystem")[0],r=this.tree.getElementsByTagName("gui")[0],s=e.getElementsByTagName("evSettings")[0];this.board.origin={},this.board.origin.usrCoords=[1,0,0],this.board.origin.scrCoords=[1,parseInt(t.getAttribute("xZero"),10),parseInt(t.getAttribute("yZero"),10)],this.board.unitX=t.getAttribute("scale")?parseInt(t.getAttribute("scale"),10):1,this.board.unitY=t.getAttribute("yscale")?parseInt(t.getAttribute("yscale"),10):this.board.unitX,this.board.fontSize=r&&r.getElementsByTagName("font")[0]?parseInt(r.getElementsByTagName("font")[0].getAttribute("size"),10):12,JXG.boards[this.board.id]=this.board,this.board.renderer.enhancedRendering=!0,"true"===s.getAttribute("grid")&&this.board.create("grid"),s.getAttribute("axes")&&("true"===s.getAttribute("axes")?(this.ggbElements.xAxis=this.board.create("axis",[[0,0],[1,0]],{strokeColor:"transparent",minorTicks:0}),this.ggbElements.yAxis=this.board.create("axis",[[0,0],[0,1]],{strokeColor:"black",minorTicks:0})):(this.ggbElements.xAxis=this.board.create("axis",[[0,0],[1,0]],{strokeColor:"transparent",ticks:{drawLabels:!1}}),this.ggbElements.yAxis=this.board.create("axis",[[0,0],[0,1]],{strokeColor:"transparent",ticks:{drawLabels:!1}})))},writeElement:function(e,t,r){var s,a,i,o,n,c,l,h,g,b,d,u,m,p,G,A,y,C,X,f,J,E,k,P,B,x,N,T,F,v,S,w,O,L,_,I,z,R,Y,V,W,M,Z,D,$,U,j,q=this,H=function(e){return function(){return e}},K=function(e){return function(){return JXG.Math.Numerics.root(B.Y,e,B)}};switch(T=JXG.isArray(e)?e[0]:e,F={},v={},JXG.debug(T),F.type=T&&T.attributes&&!JXG.exists(r)?T.getAttribute("type").toLowerCase():r,F.label=T.getAttribute("label"),v.name=F.label,JXG.debug("Constructing "+v.name+"("+F.type+"):"),F.type){case"point":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),v=this.visualProperties(T,v),this.getElement(v.name,!0)?(S=this.getElement(v.name,!0).getAttribute("exp"),w=this.ggbParse(S),F.x=new Function("return "+w[0]+";"),F.y=new Function("return "+w[1]+";")):F=this.coordinates(F,T),JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),JXG.debug(F),JXG.debug(t);try{return _=/Circle\[\s*(\w+)\s*,\s*([\d\.]+)\s*\]/.exec(t),I=/Circle\[\s*(\w+)\s*,\s*(\w+)\s*\]/.exec(t),JXG.exists(t)?JXG.exists(_)&&3===_.length?(R=this.checkElement(_[1]),Y=this.board.create("circle",[R,parseFloat(_[2])],{fillColor:"none",visible:!1,name:""}),s=this.board.create("glider",[F.x,F.y,Y],v)):JXG.exists(I)&&3===I.length?(R=this.checkElement(I[1]),l=this.checkElement(I[2]),Y=this.board.create("circle",[R,function(){return l.Value()}],{fillColor:"none",visible:!1,name:""}),s=this.board.create("glider",[F.x,F.y,Y],v)):s=JXG.isArray(t)?this.board.create("glider",[F.x,F.y,t[0]],v):this.board.create("glider",[F.x,F.y,t],v):s=this.board.create("point",[F.x,F.y],v),s}catch(e){return JXG.debug("* Err: Point "+v.name),!1}break;case"segment":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),void 0===t?t=[parseFloat(T.getElementsByTagName("coords")[0].getAttribute("z")),parseFloat(T.getElementsByTagName("coords")[0].getAttribute("x")),parseFloat(T.getElementsByTagName("coords")[0].getAttribute("y"))]:this.board.select(t[1].id).elementClass===JXG.OBJECT_CLASS_LINE&&(f="parallel");try{return JXG.debug("* Segment: ("+v.name+") First: "+t[0].name+", Last: "+t[1].name),v.straightFirst=!1,v.straightLast=!1,s=this.board.create("line",t,v)}catch(e){return JXG.debug("* Err: Segment "+v.name+" First: "+t[0].name+", Last: "+t[1].name),!1}break;case"line":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),f="line",t?this.board.select(t[1].id).elementClass===JXG.OBJECT_CLASS_LINE&&(f="parallel"):t=[parseFloat(T.getElementsByTagName("coords")[0].getAttribute("z")),parseFloat(T.getElementsByTagName("coords")[0].getAttribute("x")),parseFloat(T.getElementsByTagName("coords")[0].getAttribute("y"))];try{return s=this.board.create(f,t,v)}catch(e){return JXG.debug("* Err: Line "+v.label),!1}break;case"orthogonalline":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Orthogonalline: First: "+t[0].id+", Last: "+t[1].id),s=this.board.create("normal",t,v)}catch(e){return JXG.debug("* Err: Orthogonalline "+v.label),!1}break;case"polygon":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),3===t.length&&4!==e.length&&(t[2]=parseInt(t[2],10),f="regular");try{for(JXG.debug("* Polygon: First: "+t[0].name+", Second: "+t[1].name+", Third: "+t[2]),N=[],x=[],L="regular"===f?e.length-t[2]+2:e.length,h=1;h<L;h++)N[h-1]={},x[h-1]={},N[h-1].id="",N[h-1].name=e[h].getAttribute("label"),x[h-1]=this.colorProperties(e[h],x[h-1]),x[h-1]=this.visualProperties(e[h],x[h-1]);if(v.borders=N,O=[],"regular"===f)for(O.push(t[0]),O.push(t[1]),h=t[2]+1;h<e.length;h++)e[h].attributes?O.push(this.checkElement(e[h].getAttribute("label"))):O.push(e[h]);else for(h=0;h<t.length;h++)"object"==typeof t[h]&&O.push(t[h]);for(s="regular"===f?this.board.create("regularpolygon",O,v):this.board.create("polygon",O,v),h=0;h<s.borders.length;h++)x[h].withLabel&&s.borders[h].createLabel(),s.borders[h].setAttribute(x[h]);return s}catch(e){return JXG.debug("* Err: Polygon "+v.name),!1}break;case"intersect":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Intersection: First: "+t[0].name+", Second: "+t[1].name),JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),1===e.length?s=this.board.create("intersection",[t[0],t[1],0],v):(s=this.board.create("intersection",[t[0],t[1],1],v),G={},G=this.colorProperties(e[1],G),(G=this.visualProperties(e[1],G)).name=e[1].getAttribute("label"),b=this.board.create("otherintersection",[t[0],t[1],s],G),this.ggbElements[G.name]=b),s}catch(e){return JXG.debug("* Err: Intersection "+v.name),!1}break;case"distance":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Distance: First: "+t[0].name+", Second: "+t[1].name),l=this.board.create("midpoint",t,{visible:"false"}),v.visible="true",(s=this.board.create("text",[function(){return l.X()},function(){return l.Y()},function(){return"<span style='text-decoration: overline'>"+t[0].name+t[1].name+"</span> = "+JXG.trimNumber(JXG.toFixed(q.board.select(t[0].id).Dist(q.board.select(t[1].id)),q.decimals))}],v)).Value=function(){return q.board.select(t[0].id).Dist(q.board.select(t[1].id))},s}catch(e){return JXG.debug("* Err: Distance "+v.name),!1}break;case"vector":if(v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),T.getElementsByTagName("startPoint")[0])W=t&&2===t.length?this.checkElement(t[1].name):[parseFloat(T.getElementsByTagName("coords")[0].getAttribute("x")),parseFloat(T.getElementsByTagName("coords")[0].getAttribute("y"))],T.getElementsByTagName("startPoint")[0].getAttribute("x")&&T.getElementsByTagName("startPoint")[0].getAttribute("y")?V=[parseFloat(T.getElementsByTagName("startPoint")[0].getAttribute("x")),parseFloat(T.getElementsByTagName("startPoint")[0].getAttribute("y"))]:T.getElementsByTagName("startPoint")[0].getAttribute("exp")&&(P=T.getElementsByTagName("startPoint")[0].getAttribute("exp"),V=this.checkElement(P));else if(t&&0!==t.length)V=t[0],W=t[1];else if(S=this.getElement(T.getAttribute("label"),!0))return S=S.getAttribute("exp"),S=this.ggbParse(S),S=JXG.isArray(S)?[new Function("return "+S[1]+";"),new Function("return "+S[2]+";")]:new Function("return "+S+";"),JXG.debug("exp: "+S),s=this.board.create("arrow",[[0,0],[S[0],S[1]]],v);try{return JXG.debug("* Vector: First: "+v.name),s=this.board.create("arrow",[V,W],v)}catch(e){return JXG.debug("* Err: Vector "+v.name+W),!1}break;case"rotate":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Rotate: First: "+t[0].name+", Second: "+t[1]),v.type="rotate",JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),c=this.board.create("transform",[parseInt(t[1],10)*Math.PI/180,t[2]],{type:"rotate"}),s=this.board.create("point",[t[0],c],v)}catch(e){return JXG.debug("* Err: Rotate "+v.name),!1}break;case"dilate":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Dilate: First: "+t[0].name+", Second: "+t[1]),v.type="rotate",k=parseInt(t[1],10),E=this.board.create("transform",[k,k],{type:"scale"}),J=this.board.create("transform",[function(){return(1-k)*t[2].X()},function(){return(1-k)*t[2].Y()}],{type:"translate"}),JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),s=this.board.create("point",[t[0],[E,J]],v)}catch(e){return JXG.debug("* Err: Dilate "+v.name),!1}break;case"translate":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return c=this.board.create("transform",[function(){return t[1].point2.X()-t[1].point1.X()},function(){return t[1].point2.Y()-t[1].point1.Y()}],{type:"translate"}),JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),s=this.board.create("point",[t[0],c],v)}catch(e){return JXG.debug("* Err: Translate "+v.name),!1}break;case"mirror":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),JXG.isPoint(this.board.select(t[1].id))?f="mirrorpoint":this.board.select(t[1].id).elementClass===JXG.OBJECT_CLASS_LINE&&(f="reflection");try{return JXG.debug("* Mirror: First: "+t[0].name+", Second: "+t[1].name),s=this.board.create(f,[t[0],t[1]],v)}catch(e){return JXG.debug("* Err: Mirror "+v.name),!1}break;case"circle":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Circle: First: "+t[0].name+", Second: "+t[1]),s=this.board.create("circle",t,v)}catch(e){return JXG.debug("* Err: Circle "+v.name),!1}break;case"circlearc":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* CircleArc: First: "+t[0].name+", Second: "+t[1].name+", Third: "+t[2].name),s=this.board.create("arc",t,v)}catch(e){return JXG.debug("* Err: CircleArc "+v.name),!1}break;case"ellipse":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Ellipse: First: "+t[0].name+", Second: "+t[1].name+", Third: "+t[2]),parseInt(t[2],10)===t[2]&&(t[2]=2*parseInt(t[2],10)),s=this.board.create("ellipse",t,v)}catch(e){return JXG.debug("* Err: Ellipse "+v.name),!1}break;case"conic":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{if(t&&5===t.length)s=this.board.create("conic",t,v);else if(T.getElementsByTagName("matrix")){for(l=[],h=0;h<T.getElementsByTagName("matrix")[0].attributes.length;h++)l[h]=parseFloat(T.getElementsByTagName("matrix")[0].attributes[h].value);s=this.board.create("conic",l,v)}return s}catch(e){return JXG.debug("* Err: Conic "+v.name),!1}break;case"circlesector":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* CircleSector: First: "+t[0].name+", Second: "+t[1].name+", Third: "+t[2].name),s=this.board.create("sector",[t[0],t[1],t[2]],v)}catch(e){return JXG.debug("* Err: CircleSector "+v.name),!1}break;case"linebisector":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* LineBiSector (Mittelsenkrechte): First: "+t[0].name),l=this.board.create("midpoint",t,{visible:!1}),JXG.isPoint(this.board.select(t[0].id))&&JXG.isPoint(this.board.select(t[1].id))?(c=this.board.create("line",t,{visible:"false"}),s=this.board.create("perpendicular",[l,c],v)):s=this.board.create("perpendicular",[l,t[0]],v),s}catch(e){return JXG.debug("* Err: LineBiSector (Mittelsenkrechte) "+v.name),!1}break;case"ray":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Ray: First: "+t[0].name),v.straightFirst=!0,v.straightLast=!1,s=this.board.create("line",[t[1],t[0]],v)}catch(e){return JXG.debug("* Err: Ray "+v.name),!1}break;case"tangent":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{switch(JXG.debug("* Tangent: First: "+t[0].name+", Sec.: "+t[1].name+"("+t[1].type+")"),t[1].type){case 1330923344:return t[0].makeGlider(t[1]),s=this.board.create("tangent",[t[0]],v);case 1330922316:case 1330922319:return X=this.board.create("polar",[t[1],t[0]],{visible:!1}),C=this.board.create("intersection",[t[1],X,0],{visible:!1}),y=this.board.create("intersection",[t[1],X,1],{visible:!1}),A=this.board.create("line",[t[0],C],v),G={},G=this.colorProperties(e[1],G),(G=this.visualProperties(e[1],G)).name=e[1].getAttribute("label"),n=this.board.create("line",[t[0],y],G),this.ggbElements[G.name]=n,[A,n]}}catch(e){return JXG.debug("* Err: Tangent "+v.name+" "+G.name),!1}break;case"circumcirclearc":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* CircumcircleArc: First: "+t[0].name),s=this.board.create("circumcirclearc",t,v)}catch(e){return JXG.debug("* Err: CircumcircleArc "+v.name),!1}break;case"circumcirclesector":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* CircumcircleSector: First: "+t[0].name),s=this.board.create("circumcirclesector",[t[0],t[1],t[2]],v)}catch(e){return JXG.debug("* Err: CircumcircleSector "+v.name),!1}break;case"semicircle":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Semicircle: First: "+t[0].name),s=this.board.create("semicircle",[t[0],t[1]],v)}catch(e){return JXG.debug("* Err: Semicircle "+v.name),!1}break;case"angle":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Angle: First: "+t[0].name),s=this.board.create("angle",t,v)}catch(e){return JXG.debug("* Err: Angle "+v.name),!1}break;case"angularbisector":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),(v=this.visualProperties(T,v)).straightFirst=!0,v.straightLast=!0;try{return JXG.debug("* Angularbisector: First: "+t[0].name),s=this.board.create("bisector",t,v)}catch(e){return JXG.debug("* Err: Angularbisector "+v.name),!1}break;case"numeric":if(0===T.getElementsByTagName("slider").length)return(S=this.getElement(T.getAttribute("label"),!0))&&(S=S.getAttribute("exp"),S=this.functionParse("",S),S=this.ggbParse(S)),this.board.ggb[v.name]=new Function("return "+S+";"),JXG.debug("value: "+this.board.ggb[v.name]()),this.board.ggb[v.name];if(v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),v=this.visualProperties(T,v),1===T.getElementsByTagName("slider").length){M=parseFloat(T.getElementsByTagName("slider")[0].getAttribute("x")),Z=parseFloat(T.getElementsByTagName("slider")[0].getAttribute("y")),L=parseFloat(T.getElementsByTagName("slider")[0].getAttribute("width")),T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&"true"===T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&(M=(p=new JXG.Coords(JXG.COORDS_BY_SCREEN,[M,Z],this.board)).usrCoords[1],Z=p.usrCoords[2]),"true"===T.getElementsByTagName("slider")[0].getAttribute("horizontal")?(T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&"true"===T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&(L/=this.board.unitX),D=M+L,$=Z):(T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&"true"===T.getElementsByTagName("slider")[0].getAttribute("absoluteScreenLocation")&&(L/=this.board.unitY),D=M,$=Z+L),T.getElementsByTagName("animation")[0]&&(v.snapWidth=parseFloat(T.getElementsByTagName("animation")[0].getAttribute("step")));try{return JXG.debug("* Numeric: First: "+v.name),v.withTicks=!1,s=this.board.create("slider",[[M,Z],[D,$],[parseFloat(T.getElementsByTagName("slider")[0].getAttribute("min")),parseFloat(T.getElementsByTagName("value")[0].getAttribute("val")),parseFloat(T.getElementsByTagName("slider")[0].getAttribute("max"))]],v)}catch(e){return JXG.debug("* Err: Numeric "+v.name),!1}}break;case"midpoint":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),s=this.board.create("midpoint",t,v),JXG.debug("* Midpoint ("+s.id+"): "+v.name+"("+F.x+", "+F.y+")"),s}catch(e){return JXG.debug("* Err: Midpoint "+v.name),!1}break;case"center":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.exists(v.styleGGB)||(v.face="circle",v.fillColor=v.strokeColor,v.fillOpacity=1,v.highlightFillColor=v.strokeColor,v.highlightFillOpacity=1,v.strokeColor="black",v.strokeWidth=1),s=this.board.create("point",[function(){return q.board.select(t[0].id).center.X()},function(){return q.board.select(t[0].id).center.Y()}],v),JXG.debug("* Center ("+s.id+"): "+v.name+"("+F.x+", "+F.y+")"),s}catch(e){return JXG.debug("* Err: Center "+v.name),!1}break;case"function":for(v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),this.getElement(v.name,!0)?(U=this.getElement(v.name,!0).getAttribute("exp"),U=this.functionParse("c",U)):(U=t[0],U=this.functionParse("s",U)),JXG.debug(U),L=U.length,U[U.length-1]="return "+this.ggbParse(U[U.length-1])+";",JXG.debug(U),j=[t&&t[1]?t[1]:null,t&&t[2]?t[2]:null],z=/([x|y])\((\w+)\)/,h=0;h<2;h++)(_=z.exec(j[h]))&&(j[h]=_[1].toUpperCase()+"("+_[2]+")");try{return 1===L?s=this.board.create("functiongraph",[new Function(U[0]),j[0],j[1]],v):2===L?s=this.board.create("functiongraph",[new Function(U[0],U[1]),j[0],j[1]],v):3===L?s=this.board.create("functiongraph",[new Function(U[0],U[1],U[2]),j[0],j[1]],v):4===L?s=this.board.create("functiongraph",[new Function(U[0],U[1],U[2],U[3]),j[0],j[1]],v):5===L&&(s=this.board.create("functiongraph",[new Function(U[0],U[1],U[2],U[3],U[4]),j[0],j[1]],v)),s}catch(e){return JXG.debug("* Err: Functiongraph "+v.name),!1}break;case"polar":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Polar: First: "+t[0].name+", Sec.: "+t[1].name),s=this.board.create("polar",t,v)}catch(e){return JXG.debug("* Err: Polar "+v.name),!1}break;case"slope":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Slope ("+v.name+"): First: "+t[0].name),m=parseInt(v.slopeWidth,10)||1,u=t[0].glider||t[0].point1,b=this.board.create("point",[function(){return m+u.X()},function(){return u.Y()}],{visible:!1}),d=this.board.create("segment",[u,b],{visible:!1}),g=this.board.create("normal",[d,d.point2],{visible:!1}),h=this.board.create("intersection",[t[0],g,0],{visible:!1}),l=this.board.create("midpoint",[d.point2,h],{visible:!1}),c=this.board.create("text",[function(){return l.X()},function(){return l.Y()},function(){return"&nbsp;&nbsp;"+(m>1?m.toString():"")+" "+this.name+" = "+JXG.trimNumber(JXG.toFixed(m*t[0].getSlope(),q.decimals))}],v),v.name="",n=this.board.create("text",[function(){return(u.X()+b.X())/2},function(){return u.Y()},function(){return"<br/>"+m}],v),c.Value=function(){return t[0].getSlope()},(o=this.board.create("polygon",[u,b,h],v)).borders[2].setAttribute({visible:!1}),o.borders[0].setAttribute({strokeColor:v.fillColor,strokeWidth:v.strokeWidth,highlightStrokeColor:v.fillColor,dash:v.dash}),o.borders[1].setAttribute({strokeColor:v.fillColor,strokeWidth:v.strokeWidth,highlightStrokeColor:v.fillColor,dash:v.dash}),c}catch(e){return JXG.debug("* Err: Slope "+v.name),!1}break;case"text":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),a="";try{if(T.getElementsByTagName("isLaTeX")[0]&&"true"===T.getElementsByTagName("isLaTeX")[0].getAttribute("val")){for(this.board.options.text.useASCIIMathML=!0,z=(c=this.getElement(v.name,!0).getAttribute("exp")).match(/(.*?)" \+ (.+) \+ "(.*)/);z;)a="string"==typeof(i=this.ggbParse(RegExp.$2))?a+RegExp.$1+i:a+RegExp.$1+'" + JXG.trimNumber(JXG.toFixed('+i+", "+this.decimals+')) + "',z=(c=RegExp.$3).match(/(.*?)" \+ (.+) \+ "(.*)/);(z=c.match(/(.*?)" \+ (.+)/))?a=a+RegExp.$1+'" + JXG.trimNumber(JXG.toFixed('+this.ggbParse(RegExp.$2)+", "+this.decimals+"))":a+=c,JXG.debug("Text: "+a),s=this.board.create("text",[F.x,F.y,new Function("return "+a+";")],v)}else JXG.debug(this.getElement(v.name,!0).getAttribute("exp")),c=this.functionParse(!1,this.getElement(v.name,!0).getAttribute("exp")),c=this.ggbParse(c),JXG.debug(c[1]),s=JXG.isArray(c)?this.board.create("text",[F.x,F.y,new Function("return "+c[0]+' + " " + JXG.trimNumber(JXG.toFixed(parseFloat('+c[1]+", "+this.decimals+"));")],v):this.board.create("text",[F.x,F.y,c],v);return JXG.debug("* Text: "+c),s}catch(e){return JXG.debug("* Err: Text: "+c,e,e.stack),!1}break;case"root":for(v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v),h=0;h<e.length;h++)e[h]=this.checkElement(e[h].getAttribute("label"));for(B=JXG.isArray(t)?t[0]:t,h=0;h<e.length;h++)e[h].addConstraint([K(e[h].X()),H(0)]);return e;case"integral":v=this.boardProperties(F,T,v),v=this.colorProperties(T,v),F=this.coordinates(F,T),v=this.visualProperties(T,v);try{return JXG.debug("* Integral: First: "+t[0].name+", Sec.: "+t[1].name+", Thir.: "+t[2].name),JXG.debug([t[1](),t[2]()]),s=this.board.create("integral",[this.board.select(t[0]),[t[1],t[2]]],v)}catch(e){return JXG.debug("* Err: Integral "+v.name+W),!1}break;default:return!1}},read:function(){var e,t,r,s,a,i,o,n,c,l,h,g;for(this.writeBoard(),this.setDefaultOptions(),e=this.tree.getElementsByTagName("construction"),a=0;a<e.length;a++){for(n=e[a].getElementsByTagName("command"),i=0;i<n.length;i++){for(r=n[i],JXG.debug("now i'll parse the command:"),JXG.debug(r),c=[],s=0;s<r.getElementsByTagName("input")[0].attributes.length;s++)(t=r.getElementsByTagName("input")[0].attributes[s].value).match(/\u00B0/)||!t.match(/\D/)||t.match(/Circle/)||"Function"===r.getAttribute("name")||t===parseFloat(t)?c[s]=t:c[s]="xAxis"===t||"yAxis"===t?this.ggbElements[t]:this.checkElement(t);for(l=[],h=r.getElementsByTagName("output")[0].attributes[0].value,s=0;s<r.getElementsByTagName("output")[0].attributes.length;s++)t=r.getElementsByTagName("output")[0].attributes[s].value,l[s]=this.getElement(t);if((!JXG.exists(this.ggbElements[h])||""===this.ggbElements[h])&&(this.ggbElements[h]=this.writeElement(l,c,r.getAttribute("name").toLowerCase()),this.ggbElements[h].borders))for(s=0;s<this.ggbElements[h].borders.length;s++)this.ggbElements[this.ggbElements[h].borders[s].name]=this.ggbElements[h].borders[s]}for(JXG.debug("Restesammler: "),g=e[a].getElementsByTagName("element"),i=0;i<g.length;i++)if(t=(r=g[i]).getAttribute("label"),(!JXG.exists(this.ggbElements[t])||""===this.ggbElements)&&(this.ggbElements[t]=this.writeElement(r),o=this.getElement(t,!0)))switch(r.getAttribute("type")){case"text":case"function":break;default:this.ggbParse(o.getAttribute("exp"),t)}}this.board.unsuspendUpdate(),this.board.fullUpdate()},utf8replace:function(e){return e=e.replace(/\u03C0/g,"PI").replace(/\u00B2/g,"^2").replace(/\u00B3/g,"^3").replace(/\u225F/g,"==").replace(/\u2260/g,"!=").replace(/\u2264/g,"<=").replace(/\u2265/g,">=").replace(/\u2227/g,"&&").replace(/\u2228/g,"//")},prepareString:function(e){var t,r,s,a;if("PK"!==e.slice(0,2)&&0!==e.indexOf("<")&&("PK"!==(a=JXG.Util.Base64.decode(e)).slice(0,2)&&(a=JXG.Util.Base64.decode(e,!0)),e=a),0!==e.indexOf("<")){for(r=[],s=e.length,t=0;t<s;t++)r[t]=JXG.Util.UTF8.asciiCharCodeAt(e,t);e=new JXG.Util.Unzip(r).unzipFile("geogebra.xml")}return e=JXG.Util.UTF8.decode(e),e=this.utf8replace(e)},isGGBVector:function(e){return JXG.isArray(e)&&3===e.length&&1===e[0]}}),JXG.registerReader(JXG.GeogebraReader,["ggb","geogebra"])}();
